<?php

add_action( 'pxl_post_metabox_register', 'immigway_page_options_register' );
function immigway_page_options_register( $metabox ) {

	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'immigway' ),
					'icon'   => 'el el-refresh',
					'fields' => array_merge(
						immigway_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						immigway_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile Logo', 'immigway'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'mobile_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Mobile Style', 'immigway'),
								'options'  => array(
									'inherit'  => esc_html__('Inherit', 'immigway'),
									'light'  => esc_html__('Light', 'immigway'),
									'dark'  => esc_html__('Dark', 'immigway'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'immigway' ),
								'options'  => immigway_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky Scroll', 'immigway'),
								'options'  => array(
									'-1' => esc_html__('Inherit', 'immigway'),
									'pxl-sticky-stt' => esc_html__('Scroll To Top', 'immigway'),
									'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'immigway'),
								),
								'default'  => '-1',
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'immigway' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						immigway_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id' => 'custom_ptitle',
								'type' => 'text',
								'title' => esc_html__('Custom Page Title', 'immigway'),
							),
						)
					)
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'immigway' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						immigway_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
						)
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'immigway' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						immigway_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'p_footer_fixed',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer Fixed', 'immigway'),
								'options'  => array(
									'inherit' => esc_html__('Inherit', 'immigway'),
									'on' => esc_html__('On', 'immigway'),
									'off' => esc_html__('Off', 'immigway'),
								),
								'default'  => 'inherit',
							),
						)
					)
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'immigway' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id'          => 'body_bg_color',
								'type'        => 'color',
								'title'       => esc_html__('Body Background Color', 'immigway'),
								'transparent' => false,
								'default'     => ''
							),
							array(
								'id'          => 'primary_color',
								'type'        => 'color',
								'title'       => esc_html__('Primary Color', 'immigway'),
								'transparent' => false,
								'default'     => ''
							),
							array(
								'id'          => 'secondary_color',
								'type'        => 'color',
								'title'       => esc_html__('Secondary Color', 'immigway'),
								'transparent' => false,
								'default'     => ''
							),
							array(
								'id'          => 'third_color',
								'type'        => 'color',
								'title'       => esc_html__('Third Color', 'immigway'),
								'transparent' => false,
								'default'     => ''
							),
							array(
								'id'          => 'gradient_color',
								'type'        => 'color_gradient',
								'title'       => esc_html__('Gradient Color', 'immigway'),
								'transparent' => false,
								'default'  => array(
									'from' => '',
									'to'   => '', 
								),
							),
						)
					)
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'immigway' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id' => 'body_custom_class',
								'type' => 'text',
								'title' => esc_html__('Body Custom Class', 'immigway'),
							),
							array(
								'id'       => 'site_loader',
								'type'     => 'button_set',
								'title'    => esc_html__('Loader', 'immigway'),
								'options'  => array(
									'inherit' => esc_html__('Inherit', 'immigway'),
									'on' => esc_html__('On', 'immigway'),
									'off' => esc_html__('Off', 'immigway'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'    => 'loader_style',
								'type'  => 'select',
								'title' => esc_html__('Loader Style', 'immigway'),
								'options' => [
									'style-default'           => esc_html__('Default', 'immigway'),
									'style-digital'           => esc_html__('Digital', 'immigway'),
									'style-software'           => esc_html__('Software', 'immigway'),
									'style-business'           => esc_html__('Business', 'immigway'),
									'style-insurance'           => esc_html__('Insurance', 'immigway'),
									'style-event'           => esc_html__('Event', 'immigway'),
									'style-corporate'           => esc_html__('Corporate', 'immigway'),
									'style-startup'           => esc_html__('Startup', 'immigway'),
									'style-app'           => esc_html__('App', 'immigway'),
									'style-photography'           => esc_html__('Photography', 'immigway'),
									'style-architecture'           => esc_html__('Architecture', 'immigway'),
									'style-seo'           => esc_html__('Seo', 'immigway'),
									'style-portfolio'           => esc_html__('Portfolio Dark', 'immigway'),
									'style-portfolio2'           => esc_html__('Portfolio Light', 'immigway'),
									'style-law'           => esc_html__('Law', 'immigway'),
								],
								'default' => 'style-default',
								'indent' => true,
								'required' => array( 0 => 'site_loader', 1 => 'equals', 2 => 'on' ),
							),
							array(
								'id'      => 'loader_text',
								'type'    => 'text',
								'title'   => esc_html__('Loader Text', 'immigway'),
								'default' => '',
								'required' => array( 0 => 'loader_style', 1 => 'equals', 2 => 'style-law' ),
							),
						)
					)
				]
			]
		],
		'case_studies' => [
			'opt_name'            => 'pxl_case_studies_options',
			'display_name'        => esc_html__( 'Case Studies Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'service_external_link',
								'type' => 'text',
								'title' => esc_html__('External Link', 'immigway'),
								'validate' => 'url',
								'default' => '',
							),
							array(
								'id'=> 'service_excerpt',
								'type' => 'textarea',
								'title' => esc_html__('Excerpt', 'immigway'),
								'validate' => 'html_custom',
								'default' => '',
							),
							array(
								'id'=>'multi_text_service',
								'type' => 'multi_text',
								'title'    => esc_html__('Mutil Text', 'immigway'),
							),
							array(
								'id'       => 'icon_multi_text_service',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon Multi Text', 'immigway'),
								'force_output' => true
							),
							array(
								'id'=> 'service_price',
								'type' => 'text',
								'title' => esc_html__('Price For Service', 'immigway'),
								'default' => '',
							),
							array(
								'id'=> 'service_price_for',
								'type' => 'text',
								'title' => esc_html__('Price For Service For?', 'immigway'),
								'default' => 'Per Attempt',
							),
							array(
								'id'       => 'service_icon_type',
								'type'     => 'button_set',
								'title'    => esc_html__('Icon Type', 'immigway'),
								'options'  => array(
									'icon'  => esc_html__('Icon', 'immigway'),
									'image'  => esc_html__('Image', 'immigway'),
								),
								'default'  => 'icon'
							),
							array(
								'id'       => 'service_icon_font',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon', 'immigway'),
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
								'force_output' => true
							),
							array(
								'id'       => 'service_icon_img',
								'type'     => 'media',
								'title'    => esc_html__('Icon Image', 'immigway'),
								'default' => '',
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
								'force_output' => true
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
			]
		],
		'careers' => [
			'opt_name'            => 'pxl_careers_options',
			'display_name'        => esc_html__( 'Careers Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'careers_external_link',
								'type' => 'text',
								'title' => esc_html__('External Link', 'immigway'),
								'validate' => 'url',
								'default' => '',
							),
							array(
								'id'=> 'careers_excerpt',
								'type' => 'textarea',
								'title' => esc_html__('Excerpt', 'immigway'),
								'validate' => 'html_custom',
								'default' => '',
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
			]
		],
		'visa' => [
			'opt_name'            => 'pxl_visa_options',
			'display_name'        => esc_html__( 'Visa Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'visa_excerpt',
								'type' => 'textarea',
								'title' => esc_html__('Excerpt', 'immigway'),
								'validate' => 'html_custom',
								'default' => '',
							),
							array(
								'id'       => 'visa_icon_type',
								'type'     => 'button_set',
								'title'    => esc_html__('Icon Type', 'immigway'),
								'options'  => array(
									'icon'  => esc_html__('Icon', 'immigway'),
									'image'  => esc_html__('Image', 'immigway'),
								),
								'default'  => 'icon'
							),
							array(
								'id'       => 'visa_icon_font',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon', 'immigway'),
								'required' => array( 0 => 'visa_icon_type', 1 => 'equals', 2 => 'icon' ),
								'force_output' => true
							),
							array(
								'id'       => 'visa_icon_img',
								'type'     => 'media',
								'title'    => esc_html__('Icon Image', 'immigway'),
								'default' => '',
								'required' => array( 0 => 'visa_icon_type', 1 => 'equals', 2 => 'image' ),
								'force_output' => true
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
			]
		],
		'country' => [
			'opt_name'            => 'pxl_country_options',
			'display_name'        => esc_html__( 'Country Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=>'custom_text_buy_grid',
								'type' => 'text',
								'default' => 'Visa Service',
								'title'    => esc_html__('Custom Text', 'immigway'),
							),
							array(
								'id'=>'custom_country_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For Country Carousel', 'immigway'),
							),
							array(
								'id'=>'custom_text_link',
								'type' => 'text',
								'default' => '#',
								'title'    => esc_html__('Custom Text Link', 'immigway'),
								'validate' => 'url',
							),
							array(
								'id'=>'multi_text_country',
								'type' => 'multi_text',
								'title'    => esc_html__('Mutil Text', 'immigway'),
							),
							array(
								'id'       => 'icon_multi_text',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon Multi Text', 'immigway'),
								'force_output' => true
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'immigway' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
			]
		],
		'product' => [
			'opt_name'            => 'pxl_product_options',
			'display_name'        => esc_html__( 'Product Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'product_label',
								'type' => 'text',
								'title' => esc_html__('Label', 'immigway'),
								'default' => '',
							),
						)
					)
				],
			]
		],
		'pxl-template' => [
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'immigway' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'immigway' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'immigway'),
							'options' => [
								'df'       	   => esc_html__('Select Type', 'immigway'), 
								'header'       => esc_html__('Header', 'immigway'), 
								'footer'       => esc_html__('Footer', 'immigway'), 
								'mega-menu'    => esc_html__('Mega Menu', 'immigway'), 
								'page-title'   => esc_html__('Page Title', 'immigway'), 
								'tab' => esc_html__('Tab', 'immigway'),
								'hidden-panel' => esc_html__('Hidden Panel', 'immigway'),
								'popup' => esc_html__('Popup', 'immigway'),
								'slider' => esc_html__('Slider', 'immigway'),
							],
							'default' => 'df',
						),
						array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'immigway'),
							'options' => [
								'px-header--default'       	   => esc_html__('Default', 'immigway'), 
								'px-header--transparent'       => esc_html__('Transparent', 'immigway'),
							],
							'default' => 'px-header--default',
							'indent' => true,
							'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
						),
					),

				],
			]
		],
	];

	$metabox->add_meta_data( $panels );
}
