<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows','false');  
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');  
$drap = $widget->get_setting('drap','false');  
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl, 
    'slides_to_show_xxl'             => $col_xxl, 
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'pagination_number'             => 'true',
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed,
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-sliders pxl-testimonial-carousel pxl-testimonial-carousel2 pxl-swiper-boxshadow pxl-testimonial-style2 <?php echo esc_attr($settings['style_l2']); ?>" <?php if($drap !== 'false') : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'immigway'); ?>"<?php endif; ?>>
        <?php if(!empty($settings['wg_title']) || !empty($settings['wg_subtitle']) || !empty($settings['wg_desc'])) : ?>
            <div class="pxl-carousel-heading">
                <div class="pxl-heading">
                    <div class="pxl-heading--inner">
                        <?php if(!empty($settings['wg_subtitle'])) : ?>
                            <div class="pxl-item--subtitle px-sub-title-box1">
                                <span class="pxl-item--subtext"><?php echo esc_attr($settings['wg_subtitle']); ?></span>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--wgtitle <?php echo esc_attr($settings['pxl_wg_animate']); ?>"><?php echo esc_attr($settings['wg_title']); ?></h3>
                        <div class="pxl-item--wgdesc"><?php echo esc_attr($settings['wg_desc']); ?></div>
                    </div>
                </div>
                <?php if($pagination !== 'false' && $settings['style_l2'] == 'style-2'): ?>
                    <div class="pxl-swiper-dots style-1"></div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php if($settings['slider_row'] == '1') { ?>
                        <?php foreach ($settings['testimonial'] as $key => $value):
                            $title = isset($value['title']) ? $value['title'] : '';
                            $position = isset($value['position']) ? $value['position'] : '';
                            $desc = isset($value['desc']) ? $value['desc'] : '';
                            $image = isset($value['image']) ? $value['image'] : '';
                            ?>
                            <div class="pxl-swiper-slide">
                                <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                    <div class="pxl-top--wrap">
                                        <div class="pxl-item--top pxl-flex">
                                            <div class="pxl-item--star pxl-flex pxl-pr-20">
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                            </div>
                                            <div class="pxl-item--icon"><i class="caseicon-quote-bottom"></i></div>
                                        </div>
                                        <div class="pxl-item--desc el-empty pxl-pr-20"><?php echo pxl_print_html($desc); ?></div>
                                        <svg width="27" height="22" viewBox="0 0 27 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.5 22L26.0574 0.25H0.942632L13.5 22Z" fill="white"/></svg>
                                    </div>
                                    <div class="pxl-item--holder pxl-flex pxl-ml-30">
                                        <?php if(!empty($image['id'])) { 
                                            $img = pxl_get_image_by_size( array(
                                                'attach_id'  => $image['id'],
                                                'thumb_size' => '60x60',
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail = $img['thumbnail'];?>
                                            <div class="pxl-item--image pxl-mr-22">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                        <?php } ?>
                                        <div class="pxl-item--meta">
                                            <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h5>
                                            <div class="pxl-item--position el-empty"><?php echo pxl_print_html($position); ?></div>
                                        </div>
                                    </div>
                               </div>
                            </div>
                        <?php endforeach; ?>
                    <?php } else { ?>
                        <?php echo '<div class="pxl-swiper-slide">'; $i = 0; foreach ($settings['testimonial'] as $key => $value):
                            $title = isset($value['title']) ? $value['title'] : '';
                            $position = isset($value['position']) ? $value['position'] : '';
                            $desc = isset($value['desc']) ? $value['desc'] : '';
                            $image = isset($value['image']) ? $value['image'] : '';
                            ?>
                            
                                <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                    <div class="pxl-top--wrap">
                                        <div class="pxl-item--top pxl-flex">
                                            <div class="pxl-item--star pxl-flex pxl-pr-20">
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                                <i class="caseicon-star"></i>
                                            </div>
                                            <div class="pxl-item--icon"><i class="caseicon-quote-bottom"></i></div>
                                        </div>
                                        <div class="pxl-item--desc el-empty pxl-pr-20"><?php echo pxl_print_html($desc); ?></div>
                                        <svg width="27" height="22" viewBox="0 0 27 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.5 22L26.0574 0.25H0.942632L13.5 22Z" fill="white"/></svg>
                                    </div>
                                    <div class="pxl-item--holder pxl-flex pxl-ml-30">
                                        <?php if(!empty($image['id'])) { 
                                            $img = pxl_get_image_by_size( array(
                                                'attach_id'  => $image['id'],
                                                'thumb_size' => '60x60',
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail = $img['thumbnail'];?>
                                            <div class="pxl-item--image pxl-mr-22">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                        <?php } ?>
                                        <div class="pxl-item--meta">
                                            <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h5>
                                            <div class="pxl-item--position el-empty"><?php echo pxl_print_html($position); ?></div>
                                        </div>
                                    </div>
                               </div>
                            <?php $i++;  
                            if ($i % 2 == 0 && $i != count($settings['testimonial'])) { 
                                echo '</div><div class="pxl-swiper-slide">';
                            } ?>
                        <?php endforeach; echo "</div>" ?>
                    <?php } ?>
                </div>
            </div>
        </div>

        <?php if($pagination !== 'false' && $settings['style_l2'] == 'style-1'): ?>
            <div class="pxl-swiper-dots style-4"></div>
        <?php endif; ?>

        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrow-wrap">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>
        
    </div>
<?php endif; ?>
