<?php
$progressbar = $widget->get_setting('progressbar','false');  
$arrows = $widget->get_setting('arrows','false');  
$show_title = $widget->get_setting('show_title','false');  
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');  
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'fade', 
    'slides_to_show'                => '1',
    'slides_to_show_xxl'            => '1', 
    'slides_to_show_lg'             => '1', 
    'slides_to_show_md'             => '1', 
    'slides_to_show_sm'             => '1',
    'slides_to_show_xs'             => '1', 
    'slides_to_scroll'              => '1',
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed,
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$html_id = pxl_get_element_id($settings); 

if(isset($settings['slides']) && !empty($settings['slides']) && count($settings['slides']) && $settings['style'] == 'default'){ ?>
    <div class="pxl-swiper-sliders pxl-element-slider pxl-swiper-sliders1 pxl-swiper-nogap  <?php if($arrows !== 'false') { echo 'pxl-swiper-show-arrow'; } if($pagination !== 'false') { echo ' pxl-swiper-show-pagination'; } ?>" data-slider-mode="fade">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['slides'] as $key => $value):
                        $bg_image = isset($value['bg_image']) ? $value['bg_image'] : '';
                        $overlay_image = isset($value['overlay_image']) ? $value['overlay_image'] : '';
                        $bg_ken_burns = isset($value['bg_ken_burns']) ? $value['bg_ken_burns'] : '';
                        if(!empty($value['slide_template'])) : ?>
                            <div class="pxl-swiper-slide" id="<?php echo esc_attr($html_id.'-'.$value['_id']); ?>">
                                <div class="pxl-slider--inner elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
                                    <?php if(!empty($bg_image['id'])) :
                                        $img  = pxl_get_image_by_size( array(
                                            'attach_id'  => $bg_image['id'],
                                            'thumb_size' => 'full',
                                            'class' => 'no-lazyload'
                                        ) );
                                        $thumbnail_url = $img['url']; ?>
                                        <div class="pxl-slider--mainimage <?php if($bg_ken_burns !== 'false') { echo 'pxl-image--kenburns wow'; } ?>">
                                            <div class="pxl-slider--image bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);"></div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(!empty($overlay_image['id'])) :
                                        $overlay_img  = pxl_get_image_by_size( array(
                                            'attach_id'  => $overlay_image['id'],
                                            'thumb_size' => 'full',
                                            'class' => 'no-lazyload'
                                        ) );
                                        $overlay_thumbnail_url = $overlay_img['url']; ?>
                                        <div class="pxl-slider--overlay bg-image elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>" style="background-image: url(<?php echo esc_url($overlay_thumbnail_url); ?>);">
                                        </div>
                                    <?php endif; ?>

                                    <div class="pxl-slider--content content-align-<?php echo esc_attr($settings['content_align']); ?>">
                                        <?php $slide_content = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$value['slide_template']);
                                        pxl_print_html($slide_content); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($show_title == 'true') : ?>
            <div class="pxl-item--titles">

                <?php $count = 0;
                foreach ($settings['slides'] as $key => $title) : 
                    $count++; ?>
                    <span class="pxl-item-title pxl-cursor--cta <?php if($settings['item_active'] == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$title['_id']); ?>" tabindex="0" role="button" aria-label="Go to slide <?php echo pxl_print_html($count); ?>">
                        <span class="pxl-title--text">
                            <?php echo pxl_print_html($title['title']); ?>
                        </span>        
                    </span>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if($progressbar !== 'false'): ?>
            <div class="pxl-slider-progressbar"></div>
        <?php endif; ?>

        <?php if($pagination !== 'false'): ?>
            <div class="pxl-swiper-pagination <?php echo pxl_print_html($settings['pagination_bullet_style_horizonta_or_vertical']); ?> ">
                <div class="pxl-swiper-dots pxl-swiper-dots <?php echo pxl_print_html($settings['pagination_bullet_style']); ?> <?php echo pxl_print_html($settings['type_position']); ?> pxl-<?php echo pxl_print_html($settings['pagination_bullet_style_horizonta_or_vertical']); ?>"></div> 
            </div>
        <?php endif; ?>

        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrow-wrap">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>

    </div>
<?php } else { ?>
    <div class="pxl-swiper-sliders pxl-swiper-sliders2 pxl-element-slider <?php if($arrows !== 'false') { echo 'pxl-swiper-show-arrow'; } if($pagination !== 'false') { echo ' pxl-swiper-show-pagination'; } ?>">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['slides_l2'] as $key => $value):
                        if(!empty($value['slide_template_l2'])) : ?>
                            <div class="pxl-swiper-slide">
                                <div class="pxl-slider--inner elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
                                    <div class="pxl-slider--content content-align-<?php echo esc_attr($settings['content_align']); ?>">
                                        <?php $slide_content = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$value['slide_template_l2']);
                                        pxl_print_html($slide_content); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <?php if($progressbar !== 'false'): ?>
            <div class="pxl-slider-progressbar"></div>
        <?php endif; ?>

        <?php if($pagination !== 'false'): ?>
            <div class="pxl-swiper-pagination">
                <div class="pxl-swiper-dots <?php echo pxl_print_html($settings['pagination_bullet_style']); ?>"></div>
            </div>
        <?php endif; ?>

        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrow-wrap">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>
    </div>
<?php } ?>
