<?php 
$default_settings = [
	'style' => '',
	'text_placeholder' => '',
	'text_button' => '',
	'post_type' => '',
	'quick_user' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$text_login = immigway()->get_theme_opt('text_login',esc_html__('Login', 'immigway'));
$text_register = immigway()->get_theme_opt('text_register',esc_html__('Register', 'immigway'));
?>

<div class="pxl-icon--users icon-item h-btn-user <?php echo esc_attr($settings['style']) ?> <?php echo esc_attr($settings['show_icon_not_content']);?>">
	<?php 
	if (is_user_logged_in()) {
		$current_user = wp_get_current_user();
		$display_name = $current_user->display_name;
		?>
		<i class="far fa-user"></i> Hi, <a href="#" class="pxl-is-login"><?php echo pxl_print_html($display_name);?></a>
		<ul class="pxl-user-account">
			<?php 
			if (class_exists('WooCommerce')) {
				$my_ac = get_option('woocommerce_myaccount_page_id'); 
				?>
				<li><a href="<?php echo esc_url(get_permalink($my_ac)); ?>"><?php echo esc_html__('My Account', 'immigway'); ?></a></li>
				<?php 
			}
			?>
			<li><a href="<?php echo esc_url(wp_logout_url()); ?>"><?php echo esc_html__('Log Out', 'immigway'); ?></a></li>
		</ul>
		<?php 
	} else {
		?>
		<div class="pxl-is-not-login">
			<div class="pxl-not-login">
				<a href="javascript:void(0)" class="btn-sign-in"><?php echo pxl_print_html($text_login); ?></a>
				<span>/</span>
				<a href="javascript:void(0)" class="btn-sign-up"><?php echo pxl_print_html($text_register); ?></a>
			</div>
		</div>
		<?php 
	}
	?>
</div> 