<script src="https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.25.0/slimselect.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.25.0/slimselect.min.css" rel="stylesheet">

<?php
if (!current_user_can('manage_options')) {
    die('Sorry, you are not allowed to access this page.');
    return;
}
?>

<script language="javascript" type="text/javascript">
    function imgFlagError(image) {
        image.onerror = "";
        image.src = "<?php echo plugins_url('/images/flags/noFlag.png', AHCPRO_PLUGIN_MAIN_FILE) ?>";
        return true;
    }
</script>

 <style type="text/css">
    .ahc_main_container {
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        padding: 20px;
    }



input[type="checkbox"]:checked::before {
    transform: scale(2);
    margin: 1px;
    margin-bottom: 2px;
	 }
    .ahc-header {
        display: flex;
        align-items: center;
        margin-bottom: 30px;
        background: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .ahc-header img {
        margin-right: 15px;
    }

    .ahc-header h1 {
        margin: 0;
        font-size: 24px;
        color: #23282d;
        font-weight: 600;
    }

    .ahc-settings-icon {
        margin-left: auto;
        padding: 8px;
        border-radius: 4px;
        transition: background-color 0.2s;
    }

    .ahc-settings-icon:hover {
        background-color: #f0f0f0;
    }

    .panel {
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
        border: none;
        margin-bottom: 20px;
        overflow: hidden;
    }

    .panel-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 20px;
        margin: 0;
        font-size: 20px;
        font-weight: 600;
    }

    /* Tab Styles - Matching free version design */
    .tab-container {
        width: 100%;
        margin: 0;
    }

    .tab-navigation {
        display: flex;
        border-bottom: 2px solid #e0e0e0;
        margin-bottom: 0;
        background: #f8f9fa;
    }

    .tab-button {
        background: transparent;
        border: none;
        border-bottom: 3px solid transparent;
        padding: 18px 25px;
        cursor: pointer;
        font-size: 16px;
        font-weight: 600;
        color: #666;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .tab-button:hover {
        color: #667eea;
        border-bottom-color: #667eea;
        background: rgba(102, 126, 234, 0.05);
    }

    .tab-button.active {
        color: #667eea;
        border-bottom-color: #667eea;
        background: rgba(102, 126, 234, 0.1);
        font-weight: 700;
    }

    .tab-content {
        display: none;
        background: #fff;
        padding: 30px;
    }

    .tab-content.active {
        display: block;
    }

    .settings-section {
        margin-bottom: 35px;
        padding-bottom: 25px;
        border-bottom: 1px solid #e5e5e5;
    }

    .settings-section:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 0;
    }

    .section-title {
        font-size: 18px;
        font-weight: 600;
        color: #23282d;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
    }

    .section-title::before {
        content: '';
        width: 4px;
        height: 20px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        margin-right: 12px;
        border-radius: 2px;
    }

    .form-row {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
        align-items: flex-start;
    }

    .form-group {
        flex: 1;
    }

    .form-group.half-width {
        flex: 0 0 48%;
    }

    .form-group.quarter-width {
        flex: 0 0 23%;
    }

    .form-label {
        display: block;
        font-weight: 600;
        color: #333;
        margin-bottom: 8px;
        font-size: 14px;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 6px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #fff;
        box-sizing: border-box;
    }

    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-help {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
        font-style: italic;
    }

    .timezone-note {
        background: #e8f5e8;
        color: #2d5016;
        padding: 10px 15px;
        border-radius: 6px;
        font-size: 13px;
        border-left: 4px solid #4caf50;
        margin-top: 10px;
    }

    .checkbox-container {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 6px;
        border: 1px solid #e9ecef;
        transition: all 0.2s ease;
        margin-bottom: 15px;
    }

    .checkbox-container:hover {
        background: #f0f2f5;
    }

    .checkbox-container input[type="checkbox"] {
        margin: 0;
        width: 18px;
        height: 18px;
        accent-color: #667eea;
        cursor: pointer;
    }

    .checkbox-container input[type="checkbox"]:checked {
        background-color: #667eea;
        border-color: #667eea;
    }
	
    .checkbox-label {
        flex: 1;
        font-size: 14px;
        color: #333;
        line-height: 1.4;
    }

    .checkbox-label.warning {
        color: #d32f2f;
        font-weight: 500;
    }

    .select-container {
        position: relative;
    }

    .multi-select {
        min-height: 52px;
        padding: 10px;
    }

    .button-group {
        display: flex;
        gap: 15px;
        margin-top: 30px;
        padding-top: 25px;
        border-top: 1px solid #e5e5e5;
    }

    .btn {
        padding: 15px 30px;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        min-width: 150px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .btn-secondary {
        background: #f8f9fa;
        color: #333;
        border: 2px solid #e9ecef;
    }

    .btn-secondary:hover {
        background: #e9ecef;
        transform: translateY(-1px);
    }

    /* Legacy button support */
    .button,
    input[type="submit"],
    button[type="submit"] {
        padding: 15px 30px;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        margin-right: 15px;
        min-width: 150px;
    }

    .button-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .button-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .button-secondary {
        background: #f8f9fa;
        color: #333;
        border: 2px solid #e9ecef;
    }

    .button-secondary:hover {
        background: #e9ecef;
        transform: translateY(-1px);
    }

    .success-message {
        background: #d4edda;
        color: #155724;
        padding: 15px 20px;
        border-radius: 6px;
        border-left: 4px solid #28a745;
        margin: 20px 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

  

    .success-links {
        margin-top: 10px;
    }

    .success-links a {
        color: #155724;
        text-decoration: none;
        font-weight: 500;
        margin-right: 15px;
    }

    .success-links a:hover {
        text-decoration: underline;
    }

    /* Mobile App Instructions */
    .mobile-app-instructions {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 6px;
        border-left: 4px solid #667eea;
        font-size: 14px;
    }

    .mobile-app-instructions p {
        margin: 5px 0;
    }

    .mobile-app-instructions a {
        color: #667eea;
        text-decoration: none;
        font-weight: 500;
    }

    .mobile-app-instructions a:hover {
        text-decoration: underline;
    }

    /* Test message styling */
    #gsc-test-message {
        padding: 10px;
        border-radius: 4px;
        margin-top: 10px;
    }

    /* Legacy grid support */
    .row {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
        flex-wrap: wrap;
    }

    .col-md-6 {
        flex: 0 0 48%;
        min-width: 300px;
        box-sizing: border-box;
    }

    .col-md-12 {
        flex: 1;
        box-sizing: border-box;
    }

    /* Legacy label support */
    label {
        display: block;
        font-weight: 600;
        color: #333;
        margin-bottom: 8px;
        font-size: 14px;
    }

    .form-text,
    small {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
        font-style: italic;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }

    /* Sync Section Styles */
    #gsc-sync-status {
        border: 1px solid #dee2e6;
    }

    .sync-success {
        background: #d4edda !important;
        color: #155724 !important;
        border-left-color: #28a745 !important;
    }

    .sync-error {
        background: #f8d7da !important;
        color: #721c24 !important;
        border-left-color: #dc3545 !important;
    }

    .sync-warning {
        background: #fff3cd !important;
        color: #856404 !important;
        border-left-color: #ffc107 !important;
    }

    .spinner {
        background: url(../../../wp-admin/images/spinner.gif) no-repeat;
        background-size: 20px 20px;
        width: 20px;
        height: 20px;
        display: inline-block;
        opacity: 0.7;
        filter: alpha(opacity=70);
        vertical-align: middle;
    }

    @media (max-width: 768px) {

        .form-row,
        .row {
            flex-direction: column;
        }

        .form-group.half-width,
        .form-group.quarter-width,
        .col-md-6 {
            flex: 1;
            min-width: auto;
        }

        .tab-button {
            padding: 12px 15px;
            font-size: 14px;
        }

        .button-group {
            flex-direction: column;
        }

        .btn,
        .button {
            width: 100%;
            margin-right: 0;
            margin-bottom: 10px;
        }

        #gsc-sync-status .form-row {
            flex-direction: column;
        }
		.button-group {
    display: flex;
    gap: 15px;
    padding-top: 25px;
    margin-top: 30px;
    border-top: 2px solid #e0e0e0;
}

.button-group .button {
    border: 2px solid !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
    border-radius: 6px !important;
}

.button-group .button-primary {
    border-color: #2271b1 !important;
    background: #2271b1 !important;
    color: white !important;
}

.button-group .button-primary:hover {
    background: #135e96 !important;
    border-color: #135e96 !important;
}

.button-group .button-secondary {
    border-color: #50575e !important;
    background: white !important;
    color: #50575e !important;
}

.button-group .button-secondary:hover {
    background: #f0f0f0 !important;
    border-color: #3c434a !important;
    color: #3c434a !important;
}
		
    }
</style>

<?php
ahcpro_include_scripts();
$msg = '';
if (isset($_POST['save_general'])) {
    if (ahcpro_savesettings()) {
        $msg = '<div class="success-message" style="font-size: 16px; font-weight: bold;">Settings saved successfully!</div>';
    }
}

if (isset($_POST['save_gsc'])) {
    $json_data = stripslashes($_POST['gsc_service_account_json']);
    $decoded = json_decode($json_data, true);

    if (json_last_error() === JSON_ERROR_NONE && isset($decoded['private_key']) && isset($decoded['client_email'])) {
        update_option('ahcpro_gsc_service_account_json', $json_data);
        $msg = '<div class="success-message" style="font-size: 16px; font-weight: bold;">Service Account JSON saved successfully!</div>';
    } else if (!empty($json_data)) {
        $msg = '<div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 6px; border-left: 4px solid #dc3545; margin: 20px 0;">Invalid JSON format. Please check your Service Account JSON.</div>';
    }
}
$ahcpro_get_save_settings = ahcpro_get_save_settings();
$hits_days = isset($ahcpro_get_save_settings[0]->set_hits_days) ? $ahcpro_get_save_settings[0]->set_hits_days : 14;
$ajax_check = isset($ahcpro_get_save_settings[0]->set_ajax_check) ? ($ahcpro_get_save_settings[0]->set_ajax_check * 1000) : 10 * 1000;
$set_ips = isset($ahcpro_get_save_settings[0]->set_ips) ? $ahcpro_get_save_settings[0]->set_ips : "";
$set_google_map = isset($ahcpro_get_save_settings[0]->set_google_map) ? $ahcpro_get_save_settings[0]->set_google_map : '';
$delete_plugin_data = get_option('ahcpro_delete_plugin_data_on_uninstall');
$ahcpro_save_ips = get_option('ahcpro_save_ips_opn');
$ahcproUserRoles = get_option('ahcproUserRoles');
$ahcproExcludeRoles = get_option('ahcproExcludeRoles');
$ahcproRobots = get_option('ahcproRobots');
$ahcpro_haships = get_option('ahcpro_haships');
$ahcpro_hide_top_bar_icon = get_option('ahcpro_hide_top_bar_icon');

if ($set_ips != '') {
    $set_ips = str_ireplace(' ', '&#10;', $set_ips);
}
?>

<div class="ahc_main_container">
    <!-- Header -->
    <div class="ahc-header">
        <img width="40px" src="<?php echo esc_url(plugins_url('/images/logo.png', AHCPRO_PLUGIN_MAIN_FILE)); ?>"
            alt="Plugin Logo">
        <h1>Visitor Traffic Real Time Statistics Pro - Settings</h1>
        <a class="ahc-settings-icon" href="admin.php?page=ahc_hits_counter_menu_pro" title="Back to Dashboard">
            <img src="<?php echo esc_url(plugins_url('/images/settings.jpg', AHCPRO_PLUGIN_MAIN_FILE)); ?>"
                alt="Dashboard" />
        </a>
    </div>

    <!-- Success/Error Messages -->
    <?php echo $msg; ?>

    <!-- Main Settings Panel -->
    <div class="panel">
        <div class="tab-container">
            <div class="tab-navigation">
                <button type="button" class="tab-button active" onclick="openTab(event, 'general-tab')">General Settings</button>
                <button type="button" class="tab-button" onclick="openTab(event, 'gsc-tab')">Google Console API</button>
            </div>

          <!-- General Settings Tab -->
            <div id="general-tab" class="tab-content active">
                <form method="post" enctype="multipart/form-data" name="general_settings_form">
                    <?php $nonce = wp_create_nonce('ahc_settings_action'); ?>
                    <input type="hidden" name="ahc_settings_send" value="<?php echo esc_attr($nonce); ?>" />

                    <!-- Statistics Configuration -->
                    <div class="settings-section">
                        <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Statistics Configuration</h3>

                        <div class="form-row">
                            <div class="form-group half-width">
                                <label class="form-label" for="set_hits_days" style="font-size: 13px; font-weight: 600;">Statistics Time Range (Days)</label>
                                <input type="number" value="<?php echo esc_attr($hits_days); ?>" class="form-control"
                                    id="set_hits_days" name="set_hits_days" min="1" max="365" placeholder="14" style="font-size: 13px; padding: 8px 10px;">
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">Number of days to display in statistics charts (default: 14)</div>
                            </div>

                            <div class="form-group half-width">
                                <label class="form-label" for="set_custom_timezone" style="font-size: 13px; font-weight: 600;">Timezone</label>
                                <select class="form-control" id="set_custom_timezone" name="set_custom_timezone" style="font-size: 13px; padding: 8px 10px;">
                                    <?php
                                    $wp_timezone_string = get_option('timezone_string');
                                    $custom_timezone_offset = (get_option('ahcpro_custom_timezone') != '') ? get_option('ahcpro_custom_timezone') : $wp_timezone_string;
                                    $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                                    foreach ($timezones as $key => $value) {
                                    ?>
                                        <option value="<?php echo esc_attr($value); ?>"
                                            <?php echo ($value == $custom_timezone_offset) ? 'selected' : ''; ?>>
                                            <?php echo esc_html($value); ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <div style="background: #f0f0f1; border: 1px solid #c3c4c7; padding: 8px 10px; border-radius: 4px; font-size: 12px; color: #3c434a; margin-top: 8px;">
                                    <strong>Note:</strong> Select the same timezone in your <a href="options-general.php" target="_blank" style="color: #2271b1; text-decoration: none;">general settings</a>
                                </div>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group half-width">
                                <label class="form-label" for="set_ajax_check" style="font-size: 13px; font-weight: 600;">Online Users Check Interval (Seconds)</label>
                                <input type="number" value="<?php echo esc_attr(intval($ajax_check) / 1000); ?>"
                                    class="form-control" id="set_ajax_check" name="set_ajax_check" min="5" max="300"
                                    placeholder="10" style="font-size: 13px; padding: 8px 10px;">
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">How often to check for online users (default: 10 seconds)</div>
                            </div>

                            <div class="form-group half-width">
                                <label class="form-label" for="set_google_map" style="font-size: 13px; font-weight: 600;">Map Display Data</label>
                                <select class="form-control" name="set_google_map" id="set_google_map" style="font-size: 13px; padding: 8px 10px;">
                                    <option value="all"
                                        <?php echo ($set_google_map == 'all') ? 'selected=selected' : ''; ?>>All time visitors</option>
                                    <option value="today_visitors"
                                        <?php echo ($set_google_map == 'today_visitors') ? 'selected=selected' : ''; ?>>
                                        Today visitors per country</option>
                                    <option value="top10"
                                        <?php echo ($set_google_map == 'top10') ? 'selected=selected' : ''; ?>>Top 10 countries</option>
                                    <option value="online"
                                        <?php echo ($set_google_map == 'online') ? 'selected=selected' : ''; ?>>Online Visitors</option>
                                    <option value="this_month"
                                        <?php echo ($set_google_map == 'this_month') ? 'selected=selected' : ''; ?>>This Month Visitors</option>
                                    <option value="past_month"
                                        <?php echo ($set_google_map == 'past_month') ? 'selected=selected' : ''; ?>>Past Month Visitors</option>
                                </select>
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">Select data to display on the map visualization</div>
                            </div>
                        </div>
                    </div>

                    <!-- Exclusion Settings -->
                    <div class="settings-section" style="margin-top: 25px;">
                        <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Tracking Exclusions</h3>

                        <div class="form-row">
                            <div class="form-group half-width">
                                <label class="form-label" for="set_ips" style="font-size: 13px; font-weight: 600;">IP Addresses to Exclude</label>
                                <textarea placeholder="192.168.1.1&#10;192.168.1.2&#10;One IP per line" name="set_ips"
                                    id="set_ips" rows="4"
                                    class="form-control" style="font-size: 12px; padding: 8px 10px; font-family: 'Courier New', monospace;"><?php echo esc_html($set_ips); ?></textarea>
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">Excluded IPs will not be tracked. One per line.</div>
                            </div>

                            <div class="form-group half-width">
                                <label class="form-label" for="ahcproExcludeRoles" style="font-size: 13px; font-weight: 600;">User Roles to Exclude</label>
                                <div class="select-container">
                                    <select id="ahcproExcludeRoles" name="ahcproExcludeRoles[]" multiple="true"
                                        class="multi-select" style="font-size: 13px; padding: 8px 10px;">
                                        <?php
                                        global $wp_roles;
                                        if (!isset($wp_roles)) $wp_roles = new WP_Roles();
                                        $available_roles_names = $wp_roles->get_names();
                                        $available_roles_capable = array();

                                        foreach ($available_roles_names as $role_key => $role_name) {
                                            $available_roles_capable[$role_key] = $role_name;
                                        }

                                        $UserRoles = get_option('ahcproExcludeRoles');
                                        $UserRoles_arr = explode(',', $UserRoles);

                                        foreach ($available_roles_capable as $role) {
                                            $translated_role_name = $role;
                                            $selected_value = in_array($translated_role_name, $UserRoles_arr) ? 'selected=selected' : '';
                                        ?>
                                            <option <?php echo $selected_value; ?>
                                                value="<?php echo esc_attr($translated_role_name); ?>">
                                                <?php echo esc_html($translated_role_name); ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">Selected roles will be excluded from tracking</div>
                            </div>
                        </div>
                    </div>

                    <!-- Access Control -->
                    <div class="settings-section" style="margin-top: 25px;">
                        <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Access Control</h3>

                        <div class="form-row">
                            <div class="form-group half-width">
                                <label class="form-label" for="ahcproUserRoles" style="font-size: 13px; font-weight: 600;">Plugin Access Permissions</label>
                                <div class="select-container">
                                    <select id="ahcproUserRoles" name="ahcproUserRoles[]" multiple="true"
                                        class="multi-select" style="font-size: 13px; padding: 8px 10px;">
                                        <?php
                                        $UserRoles = get_option('ahcproUserRoles');
                                        $UserRoles_arr = explode(',', $UserRoles);

                                        foreach ($available_roles_capable as $role) {
                                            $translated_role_name = $role;
                                            $is_admin = ($translated_role_name == 'Administrator' || $translated_role_name == 'Super Admin');
                                            $selected_value = (in_array($translated_role_name, $UserRoles_arr) || $is_admin) ? 'selected=selected' : '';
                                        ?>
                                            <option <?php echo $selected_value; ?>
                                                value="<?php echo esc_attr($translated_role_name); ?>">
                                                <?php echo esc_html($translated_role_name); ?>
                                                <?php echo $is_admin ? ' (Always Enabled)' : ''; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-help" style="font-size: 12px; color: #646970; margin-top: 4px;">Select user roles that can access plugin dashboard</div>
                            </div>

                            <div class="form-group half-width">
                                <label class="form-label" style="font-size: 13px; font-weight: 600;">Mobile App Setup</label>
                                <div style="background: #f0f0f1; border: 1px solid #c3c4c7; border-radius: 4px; padding: 12px; font-size: 13px; line-height: 1.7;">
                                    <p style="margin: 0 0 8px 0;"><strong>Step 1:</strong> Download App (<a target="_blank"
                                            href="https://play.google.com/store/apps/details?id=com.codepress.trafic.trafic_static_app" style="color: #2271b1; text-decoration: none;">Google Play</a>)</p>
                                    <p style="margin: 0 0 8px 0; font-size: 13px; color: #1d2327;">
    <strong>Step 2:</strong> Generate QR Code —
    <a href="<?php echo esc_url( admin_url('admin.php?page=ahcpro_app') ); ?>" 
       style="color: #2271b1; text-decoration: none; font-weight: 500;">
        Click here
    </a>
</p>
                                    <p style="margin: 0;"><strong>Step 3:</strong> Scan QR Code in app</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Privacy & Display Options -->
                    <div class="settings-section" style="margin-top: 25px;">
                        <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Privacy & Display Options</h3>
<div class="form-row">
    <!-- Hide Top Bar Icon Checkbox -->
    <div class="form-group half-width">
        <div style="background: #f6f7f7; border: 1px solid #c3c4c7; padding: 12px; border-radius: 4px; display: flex; align-items: flex-start; gap: 10px;">
            <input type="checkbox" 
                   id="ahcpro_hide_top_bar_icon" 
                   value="1"
                   name="ahcpro_hide_top_bar_icon" 
                   style="width: 20px; height: 20px; margin-top: 2px; cursor: pointer; accent-color: #2271b1; flex-shrink: 0;"
                   <?php echo ($ahcpro_hide_top_bar_icon == 1) ? 'checked=checked' : ''; ?>>
            <label for="ahcpro_hide_top_bar_icon" style="font-size: 13px; flex: 1; cursor: pointer;">
                <strong>Hide Top Bar Icon</strong><br>
                <span style="color: #646970;">Remove plugin icon from WordPress admin top bar</span>
            </label>
        </div>
    </div>

    <!-- Hash IP Addresses Checkbox -->
    <div class="form-group half-width">
        <div style="background: #f6f7f7; border: 1px solid #c3c4c7; padding: 12px; border-radius: 4px; display: flex; align-items: flex-start; gap: 10px;">
            <input type="checkbox" 
                   id="ahcpro_haships" 
                   value="1" 
                   name="ahcpro_haships" 
                   style="width: 20px; height: 20px; margin-top: 2px; cursor: pointer; accent-color: #2271b1; flex-shrink: 0;"
                   <?php echo ($ahcpro_haships == 1) ? 'checked=checked' : ''; ?>>
            <label for="ahcpro_haships" style="font-size: 13px; flex: 1; cursor: pointer;">
                <strong>Hash IP Addresses</strong><br>
                <span style="color: #646970;">Hide last 3 digits of IPs for privacy protection</span>
            </label>
        </div>
    </div>
</div>
                        </div>
                   

                    <!-- Data Management -->
                    <div class="settings-section" style="margin-top: 25px;">
                        <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Data Management</h3>

                        <div class="form-group">
    <div style="background: #fff3cd; border: 1px solid #ffc107; border-left-width: 4px; padding: 12px; border-radius: 4px; display: flex; align-items: flex-start; gap: 10px;">
        <input 
            type="checkbox" 
            id="delete_plugin_data" 
            value="1" 
            name="delete_plugin_data" 
            style="width: 20px; height: 20px; margin-top: 2px; cursor: pointer; accent-color: #2271b1; flex-shrink: 0;">
        <label for="delete_plugin_data" style="font-size: 13px; flex: 1; cursor: pointer; color: #856404;">
            <strong>Delete All Data on Uninstall</strong><br>
            <span>WARNING: All statistics will be permanently deleted when plugin is uninstalled. This cannot be undone.</span>
        </label>
    </div>
</div>

                    </div>
					
					<div class="button-group">
    <input type="submit" name="save_general" value="Save Settings" class="button button-primary" >
    <a href="admin.php?page=ahc_hits_counter_menu_pro" class="button button-secondary"style = "margin-left: 15px !important ; border-left:2;">Back to Dashboard</a>
</div>
	

                </form>
            </div>

	<!-- Google Console API Tab -->
<div id="gsc-tab" class="tab-content">
    <form method="post" enctype="multipart/form-data" name="gsc_settings_form">
        <?php $nonce = wp_create_nonce('ahc_settings_action'); ?>
        <input type="hidden" name="ahc_settings_send" value="<?php echo esc_attr($nonce); ?>" />

        <!-- Connection Status Banner -->
        <?php
        $gsc = new GoogleSearchConsoleIntegration();
        $is_connected = $gsc->is_connected();
        $service_account_email = $gsc->get_service_account_email();
        ?>

        <?php if ($is_connected): ?>
            <div class="notice notice-success" style="padding: 12px 15px; margin-bottom: 20px; border-left-width: 4px;">
                <h3 style="margin: 0 0 6px 0; font-size: 14px; font-weight: 600;">Connected to Google Search Console</h3>
                <p style="margin: 0; font-size: 13px; line-height: 1.5; color: #1d2327;">
                    <strong>Service Account:</strong> <?php echo esc_html($service_account_email); ?><br>
                    <strong>Site URL:</strong> <?php echo esc_html(get_site_url()); ?>
                </p>
                <button type="button" id="disconnect-gsc-button" class="button button-secondary" style="margin-top: 8px; font-size: 13px; height: 30px; line-height: 28px; padding: 0 12px; color: #b32d2e;">
                    Disconnect
                </button>
            </div>
        <?php else: ?>
            <div class="notice notice-warning" style="padding: 12px 15px; margin-bottom: 20px; border-left-width: 4px;">
                <h3 style="margin: 0 0 4px 0; font-size: 14px; font-weight: 600;">Not Connected</h3>
                <p style="margin: 0; font-size: 13px; color: #1d2327;">Configure your Google Search Console API credentials below.</p>
            </div>
        <?php endif; ?>

        <div class="settings-section">
            <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">API Configuration</h3>

            <div class="form-row">
                <!-- Left Column - JSON Input -->
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="gsc_service_account_json" style="font-size: 13px; font-weight: 600;">Service Account JSON</label>
                    <textarea class="form-control" id="gsc_service_account_json" name="gsc_service_account_json" rows="8" style="font-size: 12px; font-family: 'Courier New', monospace; padding: 10px;" placeholder="Paste your Service Account JSON credentials here..."><?php echo esc_textarea(get_option('ahcpro_gsc_service_account_json', '')); ?></textarea>
                    
                    <div style="margin-top: 10px;">
                        <button type="button" id="test-gsc-button" class="button button-secondary" style="font-size: 13px; height: 32px; line-height: 30px; padding: 0 14px; background: #00a32a; border-color: #00a32a; color: #fff;">
                            Test Connection
                        </button>
                        <span style="font-size: 12px; color: #646970; margin-left: 8px;">Verify credentials work</span>
                    </div>
                    <div id="gsc-test-message" style="margin-top: 8px; font-size: 13px;"></div>
                </div>

                <!-- Right Column - Setup Guide -->
                <div class="form-group" style="flex: 1;">
                    <label style="font-size: 13px; font-weight: 600; margin-bottom: 8px; display: block; color: #1d2327;">Setup Guide</label>
                    <div style="background: #f0f0f1; border: 1px solid #c3c4c7; border-radius: 4px; padding: 12px; font-size: 13px; line-height: 1.7;">
                        <ol style="margin: 0; padding-left: 20px; color: #2c3338;">
                            <li style="margin-bottom: 8px;"><strong>Create Project:</strong> <a href="https://console.developers.google.com/" target="_blank" style="color: #2271b1; text-decoration: none;">Google Cloud Console</a> → New Project</li>
                            <li style="margin-bottom: 8px;"><strong>Enable API:</strong> APIs & Services → Library → "Search Console API" → Enable</li>
                            <li style="margin-bottom: 8px;"><strong>Service Account:</strong> Credentials → Create Credentials → Service Account</li>
                            <li style="margin-bottom: 8px;"><strong>Generate Key:</strong> Click account → Keys → Add Key → JSON</li>
                            <li style="margin-bottom: 8px;"><strong>Add to Console:</strong> Copy email → <a href="https://search.google.com/search-console/" target="_blank" style="color: #2271b1; text-decoration: none;">Search Console</a> → Settings → Users → Add (Full)</li>
                            <li><strong>Test & Save:</strong> Paste JSON → Test → Save Settings</li>
                        </ol>
                        <p style="margin: 10px 0 0 0; padding-top: 8px; border-top: 1px solid #dcdcde; font-size: 12px;">
                            <a href="https://developers.google.com/webmaster-tools/about" target="_blank" style="color: #2271b1; text-decoration: none;">View Documentation</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search Console Data Sync Section - Only visible when connected -->
        <?php if ($is_connected): ?>
        <div class="settings-section" style="margin-top: 25px;">
            <h3 class="section-title" style="font-size: 15px; margin-bottom: 15px;">Data Sync</h3>

            <div id="gsc-sync-status" style="background: #f6f7f7; border: 1px solid #c3c4c7; padding: 15px; border-radius: 4px;">
                <div style="display: flex; gap: 25px; margin-bottom: 12px; flex-wrap: wrap;">
                    <div style="flex: 1; min-width: 250px;">
                        <label style="display: block; font-size: 12px; font-weight: 600; color: #1d2327; margin-bottom: 6px;">Last Sync Status</label>
                        <div id="sync-status-display" style="font-size: 13px; color: #50575e;">
                            <span class="spinner is-active" style="float: none; margin: 0 5px 0 0;"></span>
                            Loading...
                        </div>
                    </div>
                    <div style="flex: 1; min-width: 250px;">
                        <label style="display: block; font-size: 12px; font-weight: 600; color: #1d2327; margin-bottom: 6px;">Manual Sync</label>
                        <button type="button" id="manual-gsc-sync" class="button button-primary" style="font-size: 13px; height: 32px; line-height: 30px; padding: 0 14px;">
                            Sync Now
                        </button>
                    </div>
                </div>
                <div id="sync-message" style="font-size: 13px;"></div>
                
                <div style="background: #fff; border: 1px solid #c3c4c7; padding: 12px; border-radius: 3px; margin-top: 12px;">
                    <p style="margin: 0; font-size: 13px; line-height: 1.6; color: #3c434a;">
                        <strong>How it works:</strong> Click "Sync Now" to fetch search queries from Google Search Console. Data appears in "Latest Search Words" on your dashboard. New sites may take 1-3 days to show data.
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>

<div class="button-group">
    <input type="submit" name="save_gsc" value="Save Settings" class="button button-primary" >
    <a href="admin.php?page=ahc_hits_counter_menu_pro" class="button button-secondary" style = "margin-left: 15px !important ; border-left:2;">Back to Dashboard</a>
</div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    loadSyncStatus();

    // Disconnect button handler
    const disconnectBtn = document.getElementById('disconnect-gsc-button');
    if (disconnectBtn) {
        disconnectBtn.addEventListener('click', function() {
            if (!confirm('Are you sure you want to disconnect Google Search Console? This will remove your credentials and stop syncing search data.')) {
                return;
            }

            const button = this;
            button.disabled = true;
            button.textContent = 'Disconnecting...';

            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ahcpro_disconnect_gsc',
                    nonce: '<?php echo wp_create_nonce('ahcpro_disconnect_gsc'); ?>'
                })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert('Successfully disconnected from Google Search Console. Page will reload.');
                    window.location.reload();
                } else {
                    alert('Error: ' + data.data);
                    button.disabled = false;
                    button.textContent = 'Disconnect';
                }
            })
            .catch(err => {
                alert('Request failed: ' + err.message);
                button.disabled = false;
                button.textContent = 'Disconnect';
            });
        });
    }

    // Manual sync button handler
    const syncBtn = document.getElementById('manual-gsc-sync');
    if (syncBtn) {
        syncBtn.addEventListener('click', function() {
            const button = this;
            const messageDiv = document.getElementById('sync-message');

            button.disabled = true;
            button.innerHTML = '<span class="spinner is-active" style="float: none; margin: 0 5px 0 0;"></span>Syncing...';
            messageDiv.innerHTML = '<div style="background: #e3f2fd; color: #1976d2; padding: 10px; border-radius: 4px; border-left: 3px solid #2196f3; font-size: 13px;">Syncing data from Google Search Console...</div>';

            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ahcpro_manual_gsc_sync',
                    nonce: '<?php echo wp_create_nonce('ahcpro_manual_gsc_sync'); ?>'
                })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    messageDiv.innerHTML = '<div style="background: #d4edda; color: #155724; padding: 10px; border-radius: 4px; border-left: 3px solid #28a745; font-size: 13px;">' + data.data.message + '</div>';

                    setTimeout(loadSyncStatus, 1000);

                    setTimeout(() => {
                        messageDiv.innerHTML = '';
                    }, 5000);
                } else {
                    messageDiv.innerHTML = '<div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 4px; border-left: 3px solid #dc3545; font-size: 13px;">' + data.data + '</div>';
                }
            })
            .catch(err => {
                messageDiv.innerHTML = '<div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 4px; border-left: 3px solid #dc3545; font-size: 13px;">Request failed: ' + err.message + '</div>';
            })
            .finally(() => {
                button.disabled = false;
                button.innerHTML = 'Sync Now';
            });
        });
    }

    // Function to load sync status
    function loadSyncStatus() {
        const statusDiv = document.getElementById('sync-status-display');
        if (!statusDiv) return;

        fetch(ajaxurl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                action: 'ahcpro_get_gsc_sync_status'
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const status = data.data;
                let statusHtml = '';

                if (status.has_synced) {
                    statusHtml = `
                        <div style="color: #155724;">
                            <strong>Last Sync:</strong> ${status.last_sync_human}<br>
                            <strong>Keywords Synced:</strong> ${status.last_count}<br>
                            <small style="color: #666;">Full date: ${status.last_sync}</small>
                        </div>
                    `;
                } else {
                    statusHtml = `
                        <div style="color: #856404;">
                            <strong>Never synced</strong><br>
                            <small>Click the sync button to get search data</small>
                        </div>
                    `;
                }

                statusDiv.innerHTML = statusHtml;
            } else {
                statusDiv.innerHTML = '<div style="color: #721c24;">Could not load sync status</div>';
            }
        })
        .catch(err => {
            statusDiv.innerHTML = '<div style="color: #721c24;">Error loading status</div>';
        });
    }

    // Test GSC Connection
    const testBtn = document.getElementById('test-gsc-button');
    if (testBtn) {
        testBtn.addEventListener('click', function() {
            const jsonTextarea = document.getElementById('gsc_service_account_json');
            const messageBox = document.getElementById('gsc-test-message');
            const jsonValue = jsonTextarea.value;

            if (!jsonValue.trim()) {
                messageBox.innerHTML = '<div style="color:#dc3545; font-size: 13px;">Please paste your Service Account JSON first.</div>';
                return;
            }

            messageBox.innerHTML = '<span style="color:#555; font-size: 13px;">Testing connection...</span>';

            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'test_gsc_connection',
                    nonce: '<?php echo wp_create_nonce("test_gsc_nonce"); ?>',
                    gsc_service_account_json: jsonValue
                })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    messageBox.innerHTML = `<div style="color:#28a745; background: #d4edda; padding: 10px; border-radius: 4px; border-left: 3px solid #28a745; font-size: 13px;">${data.data.message.replace(/\n/g, "<br>")}</div>`;
                } else {
                    messageBox.innerHTML = `<div style="color:#721c24; background: #f8d7da; padding: 10px; border-radius: 4px; border-left: 3px solid #dc3545; font-size: 13px;">${data.data.message}</div>`;
                }
            })
            .catch(err => {
                messageBox.innerHTML = `<div style="color:red; font-size: 13px;">Error: ${err.message}</div>`;
            });
        });
    }
});
</script>
		<script>
// Tab functionality - REQUIRED for navigation
function openTab(evt, tabName) {
    var i, tabcontent, tabbuttons;

    tabcontent = document.getElementsByClassName("tab-content");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].classList.remove("active");
    }

    tabbuttons = document.getElementsByClassName("tab-button");
    for (i = 0; i < tabbuttons.length; i++) {
        tabbuttons[i].classList.remove("active");
    }

    document.getElementById(tabName).classList.add("active");
    evt.currentTarget.classList.add("active");
}

// Additional scripts for General Settings tab
document.addEventListener('DOMContentLoaded', function() {
    // Initialize SlimSelect for multi-select dropdowns if available
    if (typeof SlimSelect !== 'undefined') {
        if (document.getElementById('ahcproExcludeRoles')) {
            new SlimSelect({
                select: '#ahcproExcludeRoles',
                settings: {
                    placeholderText: 'Select roles to exclude...',
                    searchText: 'Search roles...',
                    searchPlaceholder: 'Search...'
                }
            });
        }

        if (document.getElementById('ahcproUserRoles')) {
            new SlimSelect({
                select: '#ahcproUserRoles',
                settings: {
                    placeholderText: 'Select roles with access...',
                    searchText: 'Search roles...',
                    searchPlaceholder: 'Search...'
                }
            });
        }
    }

    // Add form validation for General Settings
    const generalForm = document.querySelector('form[name="general_settings_form"]');
    if (generalForm) {
        generalForm.addEventListener('submit', function(e) {
            var hits_days = parseInt(document.getElementById('set_hits_days').value);
            var ajax_check = parseInt(document.getElementById('set_ajax_check').value);

            if (hits_days < 1 || hits_days > 365) {
                alert('Statistics time range must be between 1 and 365 days.');
                e.preventDefault();
                return false;
            }

            if (ajax_check < 5 || ajax_check > 300) {
                alert('Online users check interval must be between 5 and 300 seconds.');
                e.preventDefault();
                return false;
            }
        });
    }
});
</script>	

