<?php
if (!defined("ABSPATH")) {
    exit();
}

$nonce = IRRPHelper::getNonce();
$mainUrl = admin_url("admin.php?page=" . self::PAGE_SETTINGS);
$redirectTo = urlencode_deep($mainUrl);

$deleteLogsUrl = admin_url("/admin-post.php?action=irrp_delete_logs&_irrp_nonce={$nonce}&redirect_to={$redirectTo}");
$downloadLogsUrl = admin_url("/admin-post.php?action=irrp_download_logs&_irrp_nonce={$nonce}");
?>
<div class="redirect-content__logs-actions logs-actions">
    <div class="logs-actions__delete-set-wrap delete-set-wrap">
        <?php
        esc_html_e("Automatically delete logs:", "redirect-redirection");
        $cronLogDelete = get_option(self::OPTIONS_CRON_LOG_DELETE);
        if (empty($cronLogDelete["option_id"])) {
            $selected = 0;
        } else {
            $selected = (int) $cronLogDelete["option_id"];
        }

        IRRPHelper::customDropdown("redirection_logs_delete", IrrPRedirection::$REDIRECTION_LOGS_DELETE, $selected);
        ?>
    </div>
    <a href="<?php echo $downloadLogsUrl; ?>" class="logs-actions__btn logs-actions__btn--download ir-download-logs" type="button">
        <svg width="16" height="16" id="icon-download" viewBox="0 0 16 16">
        <path d="M0.5 9.89999C0.632608 9.89999 0.759785 9.95267 0.853553 10.0464C0.947322 10.1402 1 10.2674 1 10.4V12.9C1 13.1652 1.10536 13.4196 1.29289 13.6071C1.48043 13.7946 1.73478 13.9 2 13.9H14C14.2652 13.9 14.5196 13.7946 14.7071 13.6071C14.8946 13.4196 15 13.1652 15 12.9V10.4C15 10.2674 15.0527 10.1402 15.1464 10.0464C15.2402 9.95267 15.3674 9.89999 15.5 9.89999C15.6326 9.89999 15.7598 9.95267 15.8536 10.0464C15.9473 10.1402 16 10.2674 16 10.4V12.9C16 13.4304 15.7893 13.9391 15.4142 14.3142C15.0391 14.6893 14.5304 14.9 14 14.9H2C1.46957 14.9 0.960859 14.6893 0.585786 14.3142C0.210714 13.9391 0 13.4304 0 12.9V10.4C0 10.2674 0.0526784 10.1402 0.146447 10.0464C0.240215 9.95267 0.367392 9.89999 0.5 9.89999Z" fill="#257671" />
        <path d="M7.6459 11.854C7.69234 11.9006 7.74752 11.9375 7.80827 11.9627C7.86901 11.9879 7.93413 12.0009 7.9999 12.0009C8.06567 12.0009 8.13079 11.9879 8.19153 11.9627C8.25228 11.9375 8.30745 11.9006 8.3539 11.854L11.3539 8.854C11.4478 8.76011 11.5005 8.63278 11.5005 8.5C11.5005 8.36722 11.4478 8.23989 11.3539 8.146C11.26 8.05211 11.1327 7.99937 10.9999 7.99937C10.8671 7.99937 10.7398 8.05211 10.6459 8.146L8.4999 10.293V1.5C8.4999 1.36739 8.44722 1.24021 8.35345 1.14645C8.25969 1.05268 8.13251 1 7.9999 1C7.86729 1 7.74011 1.05268 7.64635 1.14645C7.55258 1.24021 7.4999 1.36739 7.4999 1.5V10.293L5.3539 8.146C5.26001 8.05211 5.13268 7.99937 4.9999 7.99937C4.86712 7.99937 4.73979 8.05211 4.6459 8.146C4.55201 8.23989 4.49927 8.36722 4.49927 8.5C4.49927 8.63278 4.55201 8.76011 4.6459 8.854L7.6459 11.854Z" fill="#257671" />
        </svg>
        <span><?php esc_html_e("Download log CSV", "redirect-redirection"); ?></span>
    </a>
    <!-- changed: button => a -->
    <a href="<?php echo $deleteLogsUrl; ?>" class="logs-actions__btn logs-actions__btn--delete ir-delete-logs" type="button">
        <svg width="16" height="16" id="icon-delete" viewBox="0 0 16 16">
        <path d="M9.18182 3.27273C9.18182 2.91107 9.03815 2.56422 8.78242 2.30849C8.52669 2.05276 8.17984 1.90909 7.81818 1.90909C7.45652 1.90909 7.10968 2.05276 6.85395 2.30849C6.59821 2.56422 6.45455 2.91107 6.45455 3.27273H5.54545C5.54545 2.66996 5.7849 2.09189 6.21112 1.66567C6.63734 1.23945 7.21542 1 7.81818 1C8.42095 1 8.99902 1.23945 9.42524 1.66567C9.85146 2.09189 10.0909 2.66996 10.0909 3.27273H14.1818C14.3024 3.27273 14.418 3.32062 14.5032 3.40586C14.5885 3.4911 14.6364 3.60672 14.6364 3.72727C14.6364 3.84783 14.5885 3.96344 14.5032 4.04868C14.418 4.13393 14.3024 4.18182 14.1818 4.18182H13.6782L12.5 14.3909C12.4487 14.834 12.2363 15.2428 11.9033 15.5395C11.5702 15.8362 11.1397 16.0001 10.6936 16H4.94273C4.49668 16.0001 4.06617 15.8362 3.73311 15.5395C3.40004 15.2428 3.18766 14.834 3.13636 14.3909L1.95727 4.18182H1.45455C1.34816 4.18185 1.24513 4.14457 1.1634 4.07646C1.08167 4.00836 1.02642 3.91374 1.00727 3.80909L1 3.72727C1 3.60672 1.04789 3.4911 1.13313 3.40586C1.21838 3.32062 1.33399 3.27273 1.45455 3.27273H9.18182ZM12.7618 4.18182H2.87364L4.03909 14.2864C4.06475 14.508 4.171 14.7124 4.33763 14.8608C4.50426 15.0091 4.71963 15.0911 4.94273 15.0909H10.6936C10.9166 15.0908 11.1317 15.0088 11.2982 14.8605C11.4646 14.7122 11.5707 14.5078 11.5964 14.2864L12.7618 4.18182ZM6.45455 6.45455C6.67727 6.45455 6.86364 6.59545 6.90182 6.78091L6.90909 6.85273V12.4209C6.90909 12.64 6.70545 12.8182 6.45455 12.8182C6.23182 12.8182 6.04545 12.6773 6.00727 12.4918L6 12.42V6.85364C6 6.63364 6.20364 6.45545 6.45455 6.45545V6.45455ZM9.18182 6.45455C9.40455 6.45455 9.59091 6.59545 9.62909 6.78091L9.63636 6.85273V12.4209C9.63636 12.64 9.43273 12.8182 9.18182 12.8182C8.95909 12.8182 8.77273 12.6773 8.73455 12.4918L8.72727 12.42V6.85364C8.72727 6.63364 8.93091 6.45545 9.18182 6.45545V6.45455Z" fill="#D0302D" />
        </svg>
        <span><?php esc_html_e("Delete all logs now", "redirect-redirection"); ?></span>
    </a>
</div>