<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $el_id
 * @var $width
 * @var $css
 * @var $offset
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column_Inner
 */
$el_class = $width = $el_id = $css = $offset = '';
$output = '';
/**** ThemeStek custom changes START ****/
$css_animation = '';
/**** ThemeStek custom changes END ****/
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
$width = wpb_translateColumnWidthToSpan( $width );
$width = vc_column_offset_class_merge( $offset, $width );
$css_classes = array(
	'themestek-column-inner',
	esc_attr($this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation )),
	'wpb_column',
	'vc_column_container',
	$width,
);
if ( vc_shortcode_custom_css_has_property( $css, array(
	'border',
	'background',
) ) ) {
	$css_classes[] = 'vc_col-has-fill';
}
/**** ThemeStek custom changes START ****/
$themestek_customdiv 	= '';
$themestek_class_list 	= '';
$themestek_classes 	= array();
$themestek_classes[] 	= themestek_responsive_padding_margin_class( $themestek_responsive_css );  // Added by ThemeStek
if( !empty($themestek_textcolor) ){
	$themestek_classes[] = 'themestek-textcolor-'.$themestek_textcolor;
}
if( !empty($themestek_bgcolor) || themestek_check_if_bgcolor_in_css($css) ){
	$themestek_classes[] = 'themestek-col-bgcolor-'.$themestek_bgcolor;
	$themestek_classes[] = 'themestek-col-bgcolor-yes';
	$themestek_customdiv = '<div class="themestek-col-wrapper-bg-layer themestek-bg-layer"><div class="themestek-bg-layer-inner"></div></div>';
}
if( strpos($css, 'url(') !== false ) {
	$themestek_classes[] = 'themestek-col-bgimage-yes';
	$themestek_customdiv = '<div class="themestek-col-wrapper-bg-layer themestek-bg-layer"><div class="themestek-bg-layer-inner"></div></div>';
}
if( !empty($themestek_shadow) ){ // Shadow
	$css_classes[] = 'themestek-shadow-row';
}
if( !empty($zindex) ){
	if( $zindex=='zero' ){ $zindex='0'; }
	$css_classes[] = 'themestek-zindex-'.$zindex;
}
$themestek_class_list = implode( ' ', $themestek_classes );
/**** ThemeStek custom changes End ****/
/**** ThemeStek custom changes START ****/
if( !empty($reduce_extra_padding) ){
	$css_classes[] = 'margin-15px-' . esc_html($reduce_extra_padding) . '-colum';
}
/**** ThemeStek custom changes END ****/
$wrapper_attributes = array();
$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
/***** Modified by ThemeStek - START *****/
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="vc_column-inner <?php echo esc_html( trim( vc_shortcode_custom_css_class( $css ) ). ' ' . themestek_sanitize_html_classes( $themestek_class_list ) ); ?>">
		<?php echo themestek_wp_kses($themestek_customdiv); // Added by ThemeStek  ?> 
		<div class="wpb_wrapper">
			<?php echo wpb_js_remove_wpautop( $content ); ?>
		</div>
	</div>
</div>
<?php
/***** Modified by ThemeStek - END *****/
/**** Added by ThemeStek - code start ****/
$customStyle = '';
if(trim($css)!= ''){
	// Inline css
	global $themestek_inline_css;
	if( empty($themestek_inline_css) ){
		$themestek_inline_css = '';
	}
	// background image layer
	$new_bgimage_element    = vc_shortcode_custom_css_class( $css, '' ). ' > .themestek-col-wrapper-bg-layer';
	$newCSS   			    = str_replace( vc_shortcode_custom_css_class( $css, '' ),$new_bgimage_element,$css );
	$themestek_inline_css .= themestek_vc_get_bg_css_only( $newCSS );
	// background color layer
	$new_bgimage_element2   = vc_shortcode_custom_css_class( $css, '' ). ' > .themestek-col-wrapper-bg-layer > .themestek-bg-layer-inner';
	$newCSS2   			    = str_replace( vc_shortcode_custom_css_class( $css, '' ),$new_bgimage_element2,$css );
	$themestek_inline_css .= themestek_vc_get_bg_css_only( $newCSS2, 'nobg' );
}
// Responsive padding margin option values
if( !empty($themestek_responsive_css) ){
	global $themestek_inline_css;
	if( empty($themestek_inline_css) ){
		$themestek_inline_css = '';
	}
	$themestek_inline_css .= themestek_responsive_padding_margin( $themestek_responsive_css, '.themestek-column-inner>' );
}
/**** Added by ThemeStek - code end ****/
