<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

$opt_name = immigway()->get_option_name();
$version = immigway()->get_version();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => '', //$theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $version,
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu', //class_exists('Pxltheme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'immigway'),
    'page_title'           => esc_html__('Theme Options', 'immigway'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => 80,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'pxlart', //class_exists('Immigway_Admin_Page') ? 'case' : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'pxlart-theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'immigway'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        
    )
));

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'immigway'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'immigway'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'third_color',
            'type'        => 'color',
            'title'       => esc_html__('Third Color', 'immigway'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'immigway'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'  => ''
            ),
            'output'  => array('a')
        ),
        array(
            'id'          => 'gradient_color',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Gradient Color', 'immigway'),
            'transparent' => false,
            'default'  => array(
                'from' => '',
                'to'   => '', 
            ),
        ),
        array(
            'id'      => 'body_third_color',
            'type'    => 'color',
            'title'   => esc_html__('Body Color', 'immigway'),
            'default'     => '',
            'output'  => array('body'),
            'transparent' => false,
            'required' => array( 0 => 'pxl_body_typography', 1 => '!=', 2 => 'google-font' ),
        ),
        array(
            'id'      => 'heading_third_color',
            'type'    => 'color',
            'title'   => esc_html__('Heading Color', 'immigway'),
            'default'     => '',
            'output'  => array('h1,h2,h3,h4,h5,h6'),
            'transparent' => false,
            'required' => array( 0 => 'pxl_heading_typography', 1 => '!=', 2 => 'google-font' ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Favicon', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'immigway'),
            'default'  => '',
            'url'      => false
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mouse', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'mouse_move_animation',
            'type'     => 'switch',
            'title'    => esc_html__('Mouse Move Animation', 'immigway'),
            'default'  => false
        ),
        array(
            'id'    => 'mouse_move_style',
            'type'  => 'select',
            'title' => esc_html__('Mouse Move Style', 'immigway'),
            'options' => [
                'style-default'           => esc_html__('Default', 'immigway'),
                'style-morden'           => esc_html__('Morden', 'immigway'),
            ],
            'default' => 'style-default',
            'indent' => true,
            'required' => array( 0 => 'mouse_move_animation', 1 => 'equals', 2 => true ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Loader', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'site_loader',
            'type'     => 'button_set',
            'title'    => esc_html__('Loader', 'immigway'),
            'options'  => array(
                'on' => esc_html__('On', 'immigway'),
                'off' => esc_html__('Off', 'immigway'),
            ),
            'default'  => 'off',
        ),

        array(
            'id'    => 'loader_style',
            'type'  => 'select',
            'title' => esc_html__('Loader Style', 'immigway'),
            'options' => [
                'style-default'           => esc_html__('Default', 'immigway'),
                'style-digital'           => esc_html__('Digital', 'immigway'),
                'style-software'           => esc_html__('Software', 'immigway'),
                'style-business'           => esc_html__('Business', 'immigway'),
                'style-insurance'           => esc_html__('Insurance', 'immigway'),
                'style-event'           => esc_html__('Event', 'immigway'),
                'style-corporate'           => esc_html__('Corporate', 'immigway'),
                'style-startup'           => esc_html__('Startup', 'immigway'),
                'style-app'           => esc_html__('App', 'immigway'),
                'style-photography'           => esc_html__('Photography', 'immigway'),
                'style-architecture'           => esc_html__('Architecture', 'immigway'),
                'style-seo'           => esc_html__('Seo', 'immigway'),
                'style-portfolio'           => esc_html__('Portfolio Dark', 'immigway'),
                'style-portfolio2'           => esc_html__('Portfolio Light', 'immigway'),
                'style-law'           => esc_html__('Law', 'immigway'),
            ],
            'default' => 'style-default',
            'indent' => true,
            'required' => array( 0 => 'site_loader', 1 => 'equals', 2 => 'on' ),
        ),
        array(
            'id'      => 'loader_text',
            'type'    => 'text',
            'title'   => esc_html__('Loader Text', 'immigway'),
            'default' => '',
            'required' => array( 0 => 'loader_style', 1 => 'equals', 2 => 'style-law' ),
        ),
        array(
            'id'       => 'loader_third_color',
            'type'     => 'button_set',
            'title'    => esc_html__('Color Type', 'immigway'),
            'options'  => array(
                'primary' => esc_html__('Primary', 'immigway'),
                'gradient' => esc_html__('Gradient', 'immigway'),
            ),
            'default'  => 'primary',
            'required' => array( 0 => 'loader_style', 1 => 'equals', 2 => 'style-law' ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Cookie Policy', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'cookie_policy',
            'type'     => 'button_set',
            'title'    => esc_html__('Cookie Policy', 'immigway'),
            'options'  => array(
                'show' => esc_html__('Show', 'immigway'),
                'hide' => esc_html__('Hide', 'immigway'),
            ),
            'default'  => 'hide',
        ),
        array(
            'id'      => 'cookie_policy_description',
            'type'    => 'text',
            'title'   => esc_html__('Description', 'immigway'),
            'default' => '',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'          => 'cookie_policy_description_typo',
            'type'        => 'typography',
            'title'       => esc_html__('Description Font', 'immigway'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('.pxl-cookie-policy .pxl-item--description'),
            'units'       => 'px',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'      => 'cookie_policy_btntext',
            'type'    => 'text',
            'title'   => esc_html__('Button Text', 'immigway'),
            'default' => '',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'    => 'cookie_policy_link',
            'type'  => 'select',
            'title' => esc_html__( 'Button Link', 'immigway' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Subscribe', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'subscribe',
            'type'     => 'button_set',
            'title'    => esc_html__('Subscribe', 'immigway'),
            'options'  => array(
                'show' => esc_html__('Show', 'immigway'),
                'hide' => esc_html__('Hide', 'immigway'),
            ),
            'default'  => 'hide',
        ),
        array(
            'id'      => 'subscribe_layout',
            'type'    => 'select',
            'title'   => esc_html__('Layout', 'immigway'),
            'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','immigway'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
            'options' => immigway_get_templates_option('popup'),
            'required' => array( 0 => 'subscribe', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'    => 'popup_effect',
            'type'  => 'select',
            'title' => esc_html__('Popup Effect', 'immigway'),
            'options' => [
                'fade'           => esc_html__('Fade', 'immigway'),
                'fade-slide'           => esc_html__('Fade Slide', 'immigway'),
                'zoom'           => esc_html__('Zoom', 'immigway'),
            ],
            'default' => 'fade',
            'required' => array( 0 => 'subscribe', 1 => 'equals', 2 => 'show' ),
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'immigway'),
    'icon'   => 'el el-indent-left',
    'fields' => array_merge(
        immigway_header_opts(),
        array(
            array(
                'id'       => 'sticky_scroll',
                'type'     => 'button_set',
                'title'    => esc_html__('Sticky Scroll', 'immigway'),
                'options'  => array(
                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'immigway'),
                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'immigway'),
                ),
                'default'  => 'pxl-sticky-stb',
            ),
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'mobile_display',
            'type'     => 'button_set',
            'title'    => esc_html__('Display', 'immigway'),
            'options'  => array(
                'show'  => esc_html__('Show', 'immigway'),
                'hide'  => esc_html__('Hide', 'immigway'),
            ),
            'default'  => 'show'
        ),
        array(
            'id'       => 'mobile_style',
            'type'     => 'button_set',
            'title'    => esc_html__('Style', 'immigway'),
            'options'  => array(
                'light'  => esc_html__('Light', 'immigway'),
                'dark'  => esc_html__('Dark', 'immigway'),
            ),
            'default'  => 'light',
            'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'       => 'logo_m',
            'type'     => 'media',
            'title'    => esc_html__('Select Logo', 'immigway'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/img/logo.png'
            ),
            'url'      => false,
            'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'       => 'logo_height',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Height', 'immigway'),
            'width'    => false,
            'unit'     => 'px',
            'output'    => array('#pxl-header-default .pxl-header-branding img, #pxl-header-default #pxl-header-mobile .pxl-header-branding img, #pxl-header-elementor #pxl-header-mobile .pxl-header-branding img, .pxl-logo-mobile img'),
            'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'       => 'search_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Search Form', 'immigway'),
            'default'  => true,
            'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'      => 'search_placeholder_mobile',
            'type'    => 'text',
            'title'   => esc_html__('Search Text Placeholder', 'immigway'),
            'default' => '',
            'subtitle' => esc_html__('Default: Search...', 'immigway'),
            'required' => array( 0 => 'search_mobile', 1 => 'equals', 2 => true ),
        ),
        array(
            'id'      => 'h_mobile_btn_text',
            'type'    => 'text',
            'title'   => esc_html__('Button Text', 'immigway'),
            'default' => '',
        ),
        array(
            'id'      => 'h_mobile_btn_link',
            'type'    => 'text',
            'title'   => esc_html__('Button Link', 'immigway'),
            'default' => '',
        )
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'immigway'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array_merge(
        immigway_page_title_opts() 
    )
));


/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'immigway'),
    'icon'   => 'el el-website',
    'fields' => array_merge(
        immigway_footer_opts(),
        array(
            array(
                'id'       => 'back_totop_on',
                'type'     => 'switch',
                'title'    => esc_html__('Button Back to Top', 'immigway'),
                'default'  => false,
            ),
            array(
                'id'       => 'footer_fixed',
                'type'     => 'button_set',
                'title'    => esc_html__('Footer Fixed', 'immigway'),
                'options'  => array(
                    'on' => esc_html__('On', 'immigway'),
                    'off' => esc_html__('Off', 'immigway'),
                ),
                'default'  => 'off',
            ),
        ) 
    )
    
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Archive', 'immigway'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array_merge(
        immigway_sidebar_pos_opts([ 'prefix' => 'blog_']),
        array(
            array(
                'id'       => 'archive_date',
                'title'    => esc_html__('Date', 'immigway'),
                'subtitle' => esc_html__('Display the Date for each blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_author',
                'title'    => esc_html__('Author', 'immigway'),
                'subtitle' => esc_html__('Display the Author for each blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'      => 'archive_excerpt_length',
                'type'    => 'text',
                'title'   => esc_html__('Excerpt Length', 'immigway'),
                'default' => '',
                'subtitle' => esc_html__('Default: 50', 'immigway'),
            ),
            array(
                'id'      => 'archive_excerpt_line',
                'type'    => 'text',
                'title'   => esc_html__('Excerpt Line', 'immigway'),
                'default' => '',
                'subtitle' => esc_html__('Default: 2', 'immigway'),
            ),
            array(
                'id'      => 'archive_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__('Read More Text', 'immigway'),
                'default' => '',
                'subtitle' => esc_html__('Default: Read more', 'immigway'),
            )
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'immigway'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array_merge(
        immigway_sidebar_pos_opts([ 'prefix' => 'post_']),
        array(
            array(
                'id'       => 'pxl_post_title',
                'type'     => 'button_set',
                'title'    => esc_html__('Post Title Type', 'immigway'),
                'options'  => array(
                    'default' => esc_html__('Default', 'immigway'),
                    'custom'  => esc_html__('Custom', 'immigway'),
                ),
                'default'  => 'default',
            ),
            array(
                'id'      => 'pxl_post_title_text',
                'type'    => 'text',
                'title'   => esc_html__('Post Title Text', 'immigway'),
                'default' => '',
                'required' => array( 0 => 'pxl_post_title', 1 => 'equals', 2 => 'custom' ),
            ),
            array(
                'id'       => 'post_date',
                'title'    => esc_html__('Date', 'immigway'),
                'subtitle' => esc_html__('Display the Date for blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => true
            ),
            
            array(
                'id'       => 'post_tag',
                'title'    => esc_html__('Tags', 'immigway'),
                'subtitle' => esc_html__('Display the Tag for blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => false
            ),
            array(
                'id'       => 'post_navigation',
                'title'    => esc_html__('Navigation', 'immigway'),
                'subtitle' => esc_html__('Display the Navigation for blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'id'       => 'post_author_info',
                'title'    => esc_html__('Author Info', 'immigway'),
                'subtitle' => esc_html__('Display the Author info for blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'title' => esc_html__('Social', 'immigway'),
                'type'  => 'section',
                'id' => 'social_section',
                'indent' => true,
            ),
            array(
                'id'       => 'post_social_share',
                'title'    => esc_html__('Social', 'immigway'),
                'subtitle' => esc_html__('Display the Social Share for blog post.', 'immigway'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'id'       => 'social_facebook',
                'title'    => esc_html__('Facebook', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_twitter',
                'title'    => esc_html__('Twitter', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_pinterest',
                'title'    => esc_html__('Pinterest', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_linkedin',
                'title'    => esc_html__('LinkedIn', 'immigway'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
        )
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'immigway'),
        'icon'   => 'el el-shopping-cart',
        'fields'     => array_merge(
            immigway_sidebar_pos_opts([ 'prefix' => 'shop_']),
            array(
                array(
                    'id'       => 'shop_layout',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Layout', 'immigway'),
                    'options'  => array(
                        'grid'  => esc_html__('Grid', 'immigway'),
                        'list'  => esc_html__('List', 'immigway'),
                    ),
                    'default'  => 'grid',
                ),
                array(
                    'title'         => esc_html__('Products displayed per row', 'immigway'),
                    'id'            => 'products_columns',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show per row', 'immigway'),
                    'default'       => 3,
                    'min'           => 2,
                    'step'          => 1,
                    'max'           => 5,
                    'display_value' => 'text',
                    'required' => array( 0 => 'shop_layout', 1 => 'equals', 2 => 'grid' ),
                ),
                array(
                    'title'         => esc_html__('Products displayed per page', 'immigway'),
                    'id'            => 'product_per_page',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show', 'immigway'),
                    'default'       => 9,
                    'min'           => 3,
                    'step'          => 1,
                    'max'           => 50,
                    'display_value' => 'text'
                ),
                array(
                    'title' => esc_html__('Single Product', 'immigway'),
                    'type'  => 'section',
                    'id' => 'shop_single',
                    'indent' => true,
                ),
                array(
                    'id'       => 'product_title',
                    'type'     => 'switch',
                    'title'    => esc_html__('Product Title', 'immigway'),
                    'default'  => false
                ),
                array(
                    'id'       => 'product_social_share',
                    'type'     => 'switch',
                    'title'    => esc_html__('Social Share', 'immigway'),
                    'default'  => false
                ),
            )
        )
    ));
}
/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'immigway'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'pxl_body_typography',
            'type'     => 'select',
            'title'    => esc_html__('Body Font Type', 'immigway'),
            'options'  => array(
                'default-font'  => esc_html__('Default Font', 'immigway'),
                'google-font'  => esc_html__('Google Font', 'immigway'),
            ),
            'default'  => 'default-font',
        ),

        array(
            'id'          => 'font_body',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'immigway'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'pxl_body_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

        array(
            'id'       => 'pxl_heading_typography',
            'type'     => 'select',
            'title'    => esc_html__('Heading Font Type', 'immigway'),
            'options'  => array(
                'default-font'  => esc_html__('Default Font', 'immigway'),
                'google-font'  => esc_html__('Google Font', 'immigway'),
            ),
            'default'  => 'default-font',
        ),
        
        array(
            'id'          => 'font_heading',
            'type'        => 'typography',
            'title'       => esc_html__('Heading Google Font', 'immigway'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height'  => false,
            'font-size'  => false,
            'font-backup'  => false,
            'font-style'  => false,
            'output'      => array('h1,h2,h3,h4,h5,h6,.ft-heading-default'),
            'units'       => 'px',
            'required' => array( 0 => 'pxl_heading_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

        array(
            'id'          => 'theme_default',
            'type'        => 'typography',
            'title'       => esc_html__('Theme Default', 'immigway'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => false,
            'line-height'  => false,
            'font-size'  => false,
            'color'  => false,
            'font-style'  => false,
            'font-weight'  => false,
            'text-align'  => false,
            'units'       => 'px',
            'required' => array( 0 => 'pxl_heading_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Extra Post Type', 'immigway'),
    'icon'       => 'el el-briefcase',
    'fields'     => array(
        array(
            'title' => esc_html__('Case Studies', 'immigway'),
            'type'  => 'section',
            'id' => 'post_case_studies',
            'indent' => true,
        ),
        array(
            'id'       => 'case_studies_display',
            'type'     => 'switch',
            'title'    => esc_html__('Case Studies', 'immigway'),
            'default'  => true
        ),
        array(
            'id'      => 'case_studies_slug',
            'type'    => 'text',
            'title'   => esc_html__('Case Studies Slug', 'immigway'),
            'default' => '',
            'desc'     => 'Default: case-studies',
            'required' => array( 0 => 'case_studies_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'case_studies_name',
            'type'    => 'text',
            'title'   => esc_html__('Case Studies Name', 'immigway'),
            'default' => '',
            'desc'     => 'Default: Case Studies',
            'required' => array( 0 => 'case_studies_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_case_studies_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'immigway' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'case_studies_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),

        array(
            'title' => esc_html__('Country', 'immigway'),
            'type'  => 'section',
            'id' => 'post_country',
            'indent' => true,
        ),
        array(
            'id'       => 'country_display',
            'type'     => 'switch',
            'title'    => esc_html__('Country', 'immigway'),
            'default'  => true
        ),
        array(
            'id'      => 'country_slug',
            'type'    => 'text',
            'title'   => esc_html__('Country Slug', 'immigway'),
            'default' => '',
            'desc'     => 'Default: country',
            'required' => array( 0 => 'country_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'country_name',
            'type'    => 'text',
            'title'   => esc_html__('Country Name', 'immigway'),
            'default' => '',
            'desc'     => 'Default: Country',
            'required' => array( 0 => 'country_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_country_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'immigway' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'country_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),

        array(
            'title' => esc_html__('Service', 'immigway'),
            'type'  => 'section',
            'id' => 'post_service',
            'indent' => true,
        ),
        array(
            'id'       => 'service_display',
            'type'     => 'switch',
            'title'    => esc_html__('Service', 'immigway'),
            'default'  => true
        ),
        array(
            'id'      => 'service_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Slug', 'immigway'),
            'default' => '',
            'desc'     => 'Default: service',
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'service_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Name', 'immigway'),
            'default' => '',
            'desc'     => 'Default: Services',
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_service_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'immigway' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),

        array(
            'title' => esc_html__('Visa', 'immigway'),
            'type'  => 'section',
            'id' => 'post_visa',
            'indent' => true,
        ),
        array(
            'id'       => 'visa_display',
            'type'     => 'switch',
            'title'    => esc_html__('Visa', 'immigway'),
            'default'  => true
        ),
        array(
            'id'      => 'visa_slug',
            'type'    => 'text',
            'title'   => esc_html__('Visa Slug', 'immigway'),
            'default' => '',
            'desc'     => 'Default: visa',
            'required' => array( 0 => 'visa_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'visa_name',
            'type'    => 'text',
            'title'   => esc_html__('Visa Name', 'immigway'),
            'default' => '',
            'desc'     => 'Default: Visas',
            'required' => array( 0 => 'visa_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_visa_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'immigway' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'visa_display', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
    )
));