<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_timeline',
        'title' => esc_html__('BR Timeline', 'immigway'),
        'icon' => 'eicon-editor-link',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'immigway'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'timeline',
                            'label' => esc_html__('timeline', 'immigway'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'time',
                                    'label' => esc_html__('Time', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'decs_time',
                                    'label' => esc_html__('Description Time', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Title', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'decs',
                                    'label' => esc_html__('Description', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'it_active',
                                    'label' => esc_html__('Active', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '',
                                    'options' => [
                                        '' => esc_html__('Default', 'immigway' ),
                                        'active' => esc_html__('Active', 'immigway' ),
                                    ],
                                ),
                                array(
                                    'name' => 'space_bottom',
                                    'label' => esc_html__('Space Top', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'size_units' => [ 'px', '%' ],
                                    'range' => [
                                        'px' => [
                                            'min' => -100,
                                            'max' => 100,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} {{CURRENT_ITEM}} ' => 'margin-top: {{SIZE}}{{UNIT}};',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ text }}}',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_link',
                    'label' => esc_html__('Style', 'immigway'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'height_line',
                            'label' => esc_html__('Height Procces', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline:after ' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'immigway' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'immigway' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'immigway' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'immigway' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'immigway' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline' => 'text-align: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'time_color',
                            'label' => esc_html__('Time Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline .time' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'time_color_darkmode',
                            'label' => esc_html__('Time Color Dark Mode ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '.dark-mode {{WRAPPER}} .pxl-timeline .time' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'time_typography',
                            'label' => esc_html__('Time Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-timeline .time',
                        ),  
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline .title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color_dark',
                            'label' => esc_html__('Title Color Dark Mode', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '.dark-mode {{WRAPPER}} .pxl-timeline .title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-timeline .title',
                        ),
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Description Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline .desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_color_dark',
                            'label' => esc_html__('Description Color Dark Mode', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '.dark-mode {{WRAPPER}} .pxl-timeline .desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Description Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-timeline .desc',
                        ),
                        array(
                            'name' => 'line_color',
                            'label' => esc_html__('Line Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline .line ' => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-timeline:before ' => 'border-left-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'line_color_dark',
                            'label' => esc_html__('Line Color Dark Mode', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '.dark-mode {{WRAPPER}} .pxl-timeline .line ' => 'background-color: {{VALUE}};',
                                '.dark-mode {{WRAPPER}} .pxl-timeline:before ' => 'border-left-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bottom_spacer',
                            'label' => esc_html__('Bottom Spacer', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-timeline li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
),
immigway_widget_animation_settings(),
),
),
),
immigway_get_class_widget_path()
);