<?php

// Register Bar Charts Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_bar_chart',
        'title' => esc_html__('BR Bar Chart', 'immigway'),
        'icon' => 'eicon-time-line',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'chart-js',
            'immigway-bar-chart',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_line_chart',
                    'label' => esc_html__('Piecharts', 'immigway'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'x_ax',
                            'label' => esc_html__('X-axis values', 'immigway'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'default' => '2020;2019;2018;2017;2016;2015',
                        ),
                        array(
                            'name' => 'values',
                            'label' => esc_html__('Values', 'immigway'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'default' => [],
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'y_ax',
                                    'label' => esc_html__('Y-axis values', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'border_color',
                                    'label' => esc_html__('Border Color', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                ),
                                array(
                                    'name' => 'bg_color',
                                    'label' => esc_html__('Background Color', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                ),
                            ),
                            'default' => [
                                [
                                    'title' => 'Business',
                                    'y_ax' => '5000;7500;4000;14000;9000;24000',
                                ],
                                [
                                    'title' => 'Finance',
                                    'y_ax' => '12500;11000;22000;17000;27000;26500',
                                ],
                                [
                                    'title' => 'Consulting',
                                    'y_ax' => '16000;19000;28000;24000;32000;36500',
                                ],
                            ],
                            'title_field' => '{{{ title }}}',
                        ),
                    ),
                ),
                immigway_widget_animation_settings(),
            ),
        ),
    ),
    immigway_get_class_widget_path()
);