<?php
$col_xs = '1';
$col_sm = '1';
$col_md = '1';
$col_lg = '1';
$col_xl = '1';
$col_xxl = '1';
$slides_to_scroll = '1';
$arrows = $widget->get_setting('arrows','false');  
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');  
$drap = $widget->get_setting('drap','false');  
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'fade', 
    'slides_to_show'                => $col_xl, 
    'slides_to_show_xxl'            => $col_xxl, 
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'pagination_number'             => 'true',
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed,
];
$widget->add_render_attribute('carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$html_id = pxl_get_element_id($settings);
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$tab_bd_ids = [];

if (isset($settings['tabs']) && !empty($settings['tabs']) && count($settings['tabs'])) : ?>
    <div class="pxl-swiper-sliders pxl-template-carousel pxl-template-carousel1 pxl-swiper-arrow-show <?php if ($arrows == 'true') { echo esc_attr__('pxl-show-arrow', 'immigway'); } ?>" data-view-auto="<?php echo esc_attr($col_xl); ?>">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string('carousel')); ?>>
                <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['tabs'] as $key => $content) : ?>
                    <div class="pxl-swiper-slide">
                    <div class="pxl-item--inner pxl-transtion <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <div id="<?php echo esc_attr($html_id.'-'.$content['_id']); ?>" class="pxl-item--content ">
                        <?php if(!empty($content['content_template'])) {
                            $tab_content = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$content['content_template']);
                            $tab_bd_ids[] = (int)$content['content_template'];
                            pxl_print_html($tab_content);
                        } ?>
                    </div>
                </div>
            </div>

        <?php endforeach; ?>
    </div>
</div>
<?php if($pagination !== 'false'): ?>
    <div class="pxl-swiper-dots <?php echo pxl_print_html($settings['pagination_bullet_style']); ?>"></div>
<?php endif; ?>

<?php if($arrows !== 'false'): ?>
    <div class="pxl-swiper-arrow-wrap">
        <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
        <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
    </div>
<?php endif; ?>
</div>
</div>
<?php endif; ?>
