<?php if ( ! empty( $settings['item_link']['url'] ) ) {
	$widget->add_render_attribute( 'item_link', 'href', $settings['item_link']['url'] );

	if ( $settings['item_link']['is_external'] ) {
		$widget->add_render_attribute( 'item_link', 'target', '_blank' );
	}

	if ( $settings['item_link']['nofollow'] ) {
		$widget->add_render_attribute( 'item_link', 'rel', 'nofollow' );
	} ?>

<?php } ?>
<div class="pxl-banner pxl-banner1">
	<div class="pxl-banner-inner">
		<a class="pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'item_link' )); ?>></a>
		<?php if(!empty($settings['banner_image']['id'])) : 
			$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '522x609'; 
			$img = pxl_get_image_by_size( array(
				'attach_id'  => $settings['banner_image']['id'],
				'thumb_size' => $image_size,
				'class' => 'pxl-image-banner'
			));
			$thumbnail = $img['thumbnail'];
			?>
			<div class="pxl-item--image">
				<div class="pxl-item-img-primary <?php echo esc_attr($settings['pxl_animate_img1']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_img1']); ?>ms">
					<?php echo pxl_print_html($thumbnail); ?>
				</div>
			</div>
		<?php endif; ?>
		<div class="pxl-wrap-content">
			<div class="pxl-wrap-shape">
				<svg class="pxl-svg-1" width="422" height="328" viewBox="0 0 422 328" xmlns="http://www.w3.org/2000/svg">
					<path d="M0.287109 240.142C20.2871 205.285 96.63 135.228 242.001 133.856C385.076 132.507 421.433 46.9123 422.001 2.26061V0.14209C422.01 0.837364 422.011 1.54371 422.001 2.26061V327.571H0.287109V240.142Z"/>
				</svg>
				<svg class="pxl-svg-2" width="422" height="329" viewBox="0 0 422 329" xmlns="http://www.w3.org/2000/svg">
					<path d="M199.142 146.428C96.2852 139.571 23.7137 193.857 0.285156 221.857V328.142H421.999V0.713623C387.714 112.142 327.714 154.999 199.142 146.428Z"/>
				</svg>
			</div>
			<div class="pxl-content">

				<div class="pxl-item--title"><?php echo esc_attr($settings['banner_title']); ?></div>
				<div class="pxl-item-contact-info">
					<div class="pxl-item--icon">
						<?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
					</div>
					<span class="pxl-item--desc"><?php echo esc_attr($settings['banner_phone_desc']); ?></span>
					<h5 class="pxl-item--number"><?php echo esc_attr($settings['banner_phone_number']); ?></h5>
				</div>
			</div>
		</div>
	</div>
</div>