<?php
// [themestek-socialbox]
if( !function_exists('themestek_sc_social_box') ){
function themestek_sc_social_box( $atts, $content=NULL ){
	
	$return = '';
	
	if( function_exists('vc_map') ){
		
		global $themestek_sc_params_socialbox;
		$options_list = themestek_create_options_list($themestek_sc_params_socialbox);
		
		extract( shortcode_atts(
			$options_list
		, $atts ) );
		
		
		
		// Class list
		$class = array();
		$class[] = 'themestek-socialbox-wrapper';
		$class[] = 'themestek-socialbox-icon-size-' . $iconsize;
		$class[] = 'themestek-socialbox-column-'.$column;
		
		
		// CSS Animation
		if ( !empty( $css_animation ) ) {
			$class[] = themestek_getCSSAnimation( $css_animation );
		}
		
		// Extra Class
		if( !empty($el_class) ){
			$class[] = $el_class;
		}
		
		// VC custom class
		if ( ! empty( $css ) ) {
			$class[] = themestek_vc_shortcode_custom_css_class( $css );
		}
		
		// Extra class name
		$extraClass = '';
		/*if( isset($options_list['el_class']) && trim($options_list['el_class'])!='' ){
			$class[] = trim($options_list['el_class']);
			$options_list['el_class'] = '';
		}*/
		
		$columnclass = 'col-md-3 col-lg-3 col-xs-12';
		switch($column){
			case 'one':
				$columnclass = 'col-md-12 col-lg-12 col-xs-12';
				break;
				
			case 'two':
				$columnclass = 'col-md-6 col-lg-6 col-xs-12';
				break;
			
			case 'three':
				$columnclass = 'col-md-4 col-lg-4 col-xs-12';
				break;
				
			case 'four':
				$columnclass = 'col-md-3 col-lg-3 col-xs-12';
				break;
			
			case 'five':
				$columnclass = 'col-md-20percent col-lg-20percent col-xs-12';
				break;
			
			case 'six':
				$columnclass = 'col-md-4 col-lg-2 col-xs-12';
				break;
		}
		
		
		// prearing shortcode
		$ctaShortcode = '[themestek-heading ';
		foreach( $options_list as $key=>$val ){
			if( trim( ${$key} )!='' && $key!='el_class' && $key!='css' ){
				$ctaShortcode .= ' '.$key.'="'.${$key}.'" ';
			}
		}
		$ctaShortcode .= 'el_width="100%" css_animation=""][/themestek-heading]';
		
		
		// calling CTA shortcode
		$return = '';
		$return = do_shortcode($ctaShortcode);
		
		
		// Add/remove separator line below main heading text
		$heading_sep_class = ' themestek-heading-with-separator';
		if( !empty($heading_sep) && $heading_sep=='no' ){
			$heading_sep_class = '';
		}
		$class[] = $heading_sep_class;
		
		
		
		// Social list
		$sociallist = array(
			'twitter'      => 'Twitter',
			'youtube'      => 'YouTube',
			'flickr'       => 'Flickr',
			'facebook'     => 'Facebook',
			'linkedin'     => 'LinkedIn',
			'gplus'        => 'Google+',
			'yelp'         => 'Yelp',
			'dribbble'     => 'Dribbble',
			'pinterest'    => 'Pinterest',
			'podcast'      => 'Podcast',
			'instagram'    => 'Instagram',
			'xing'         => 'Xing',
			'vimeo'        => 'Vimeo',
			'vk'           => 'VK',
			'houzz'        => 'Houzz',
			'issuu'        => 'Issuu',
			'google-drive' => 'Google Drive',
			'rss'          => 'RSS Feed',
		);
		
		
		
		
		// social service list
		$socialdata = json_decode(urldecode($socialservices));
		
		// CSS Animation
		if ( !empty( $css_animation ) ) {
			$class[] = themestek_getCSSAnimation( $css_animation );
		}
		
		$return .= '<div class="themestek-socialbox-links-wrapper row multi-columns-row">';
		
		if( is_array($socialdata) && count($socialdata)>0 ){
			foreach( $socialdata as $data ){
				if( !empty($data->servicename) ){
					
					// Social link
					if( $data->servicename=='rss' ){
						$servicelink = get_bloginfo('rss2_url');
					} else {
						$servicelink = ( isset($data->servicelink) && trim($data->servicelink)!='' ) ? $data->servicelink : '#' ;
					}
					
					// Preparing icon
					$servicename = ( isset($sociallist[$data->servicename]) ) ? $sociallist[$data->servicename] : $data->servicename ;
					$return .= '<div class="themestek-socialbox-i-wrapper '.$columnclass.'">';
					$return .= '<a class="themestek-socialbox-icon-link themestek-socialbox-icon-link-'.$data->servicename.'" target="_blank" href="'.$servicelink.'" data-tooltip="'.$servicename.'"><i class="themestek-liviza-icon-'.$data->servicename.'"></i></a>';
					$return .= '</div>';
					
				}
			}
		}
		
		$return .= '</div><!-- .themestek-socialbox-links-wrapper -->  ';
		
		
		// class list
		$class = implode(' ', $class );
		
		// preparing final output
		$return = '<div class="' . $class . '">' . $return . '</div>';
		
		
	} else {
		$return .= '<!-- Visual Composer plugin not installed. Please install it to make this shortcode work. -->';
	}
		
	// final return
	return $return;
	
	
}
}
add_shortcode( 'themestek-socialbox', 'themestek_sc_social_box' );