<?php


/******************* Helper Functions ************************/

/**
 *
 * Encode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_encode_string' ) ) {
	function cs_encode_string( $string ) {
		return rtrim( strtr( call_user_func( 'base'. '64' .'_encode', addslashes( gzcompress( serialize( $string ), 9 ) ) ), '+/', '-_' ), '=' );
	}
}

/**
 *
 * Decode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_decode_string' ) ) {
	function cs_decode_string( $string ) {
		return unserialize( gzuncompress( stripslashes( call_user_func( 'base'. '64' .'_decode', rtrim( strtr( $string, '-_', '+/' ), '=' ) ) ) ) );
	}
}



/*************** Demo Content Settings *******************/
function themestek_action_rss2_head(){
	// Get theme configuration
	$sidebars = get_option('sidebars_widgets');
	// Get Widgests configuration
	$sidebars_config = array();
	foreach ($sidebars as $sidebar => $widget) {
		if ($widget && is_array($widget)) {
			foreach ($widget as $name) {
				$name = preg_replace('/-\d+$/','',$name);
				$sidebars_config[$name] = get_option('widget_'.$name);
			}
		}
	}

	// Get Menus
	$locations = get_nav_menu_locations();
	$menus     = wp_get_nav_menus();
	$menuList  = array();
	foreach( $locations as $location => $menuid ){
		if( $menuid!=0 && $menuid!='' && $menuid!=false ){
			if( is_array($menus) && count($menus)>0 ){
				foreach( $menus as $menu ){
					if( $menu->term_id == $menuid ){
						$menuList[$location] = $menu->name;
					}
				}
			}
		}
	}

	$config = array(
			'page_for_posts'   => get_the_title( get_option('page_for_posts') ),
			'show_on_front'    => get_option('show_on_front'),
			'page_on_front'    => get_the_title( get_option('page_on_front') ),
			'posts_per_page'   => get_option('posts_per_page'),
			'sidebars_widgets' => $sidebars,
			'sidebars_config'  => $sidebars_config,
			'menu_list'        => $menuList,
		);
	if ( defined('THEMESTEK_THEME_DEVELOPMENT') ) {
		echo sprintf('<wp:theme_custom>%s</wp:theme_custom>', base64_encode(serialize($config)));
	}
}

if ( defined('THEMESTEK_THEME_DEVELOPMENT') ) {
	add_action('rss2_head', 'themestek_action_rss2_head');
}

/**********************************************************/




if( !class_exists( 'themestek_liviza_one_click_demo_setup' ) ) {


	class themestek_liviza_one_click_demo_setup{


		function __construct(){
			add_action( 'wp_ajax_liviza_install_demo_data', array( &$this , 'ajax_install_demo_data' ) );
		}


		/**
		 * Decide if the given meta key maps to information we will want to import
		 *
		 * @param string $key The meta key to check
		 * @return string|bool The key if we do want to import, false if not
		 */
		function is_valid_meta_key( $key ) {
			// skip attachment metadata since we'll regenerate it from scratch
			// skip _edit_lock as not relevant for import
			if ( in_array( $key, array( '_wp_attached_file', '_wp_attachment_metadata', '_edit_lock' ) ) )
				return false;
			return $key;
		}




		/**
		 * Added to http_request_timeout filter to force timeout at 60 seconds during import
		 * @return int 60
		 */
		function bump_request_timeout() {
			return 600;
		}



		/**
		 * Map old author logins to local user IDs based on decisions made
		 * in import options form. Can map to an existing user, create a new user
		 * or falls back to the current user in case of error with either of the previous
		 */
		function get_author_mapping() {

			if ( ! isset( $_POST['imported_authors'] ) )
				return;

			$create_users = $this->allow_create_users();

			foreach ( (array) $_POST['imported_authors'] as $i => $old_login ) {
				// Multisite adds strtolower to sanitize_user. Need to sanitize here to stop breakage in process_posts.
				$santized_old_login = sanitize_user( $old_login, true );
				$old_id = isset( $this->authors[$old_login]['author_id'] ) ? intval($this->authors[$old_login]['author_id']) : false;

				if ( ! empty( $_POST['user_map'][$i] ) ) {
					$user = get_userdata( intval($_POST['user_map'][$i]) );
					if ( isset( $user->ID ) ) {
						if ( $old_id )
							$this->processed_authors[$old_id] = $user->ID;
						$this->author_mapping[$santized_old_login] = $user->ID;
					}
				} else if ( $create_users ) {
					if ( ! empty($_POST['user_new'][$i]) ) {
						$user_id = wp_create_user( $_POST['user_new'][$i], wp_generate_password() );
					} else if ( $this->version != '1.0' ) {
						$user_data = array(
							'user_login' => $old_login,
							'user_pass' => wp_generate_password(),
							'user_email' => isset( $this->authors[$old_login]['author_email'] ) ? $this->authors[$old_login]['author_email'] : '',
							'display_name' => $this->authors[$old_login]['author_display_name'],
							'first_name' => isset( $this->authors[$old_login]['author_first_name'] ) ? $this->authors[$old_login]['author_first_name'] : '',
							'last_name' => isset( $this->authors[$old_login]['author_last_name'] ) ? $this->authors[$old_login]['author_last_name'] : '',
						);
						$user_id = wp_insert_user( $user_data );
					}

					if ( ! is_wp_error( $user_id ) ) {
						if ( $old_id )
							$this->processed_authors[$old_id] = $user_id;
						$this->author_mapping[$santized_old_login] = $user_id;
					} else {
						printf( __( 'Failed to create new user for %s. Their posts will be attributed to the current user.', 'liviza-demosetup' ), esc_html($this->authors[$old_login]['author_display_name']) );
						if ( defined('IMPORT_DEBUG') && IMPORT_DEBUG )
							echo ' ' . $user_id->get_error_message();
						echo '<br />';
					}
				}

				// failsafe: if the user_id was invalid, default to the current user
				if ( ! isset( $this->author_mapping[$santized_old_login] ) ) {
					if ( $old_id )
						$this->processed_authors[$old_id] = (int) get_current_user_id();
					$this->author_mapping[$santized_old_login] = (int) get_current_user_id();
				}
			}
		}



		/**
		 * Install demo data
		 **/
		function ajax_install_demo_data() {

			// Maximum execution time
			@ini_set('max_execution_time', 60000);
			@set_time_limit(60000);

			define('WP_LOAD_IMPORTERS', true);
			include_once( THEMESTEK_LIVIZA_DIR .'demo-content-setup/one-click-demo/wordpress-importer/wordpress-importer.php' );
			$included_files = get_included_files();


			$WP_Import = new themestek_WP_Import;

			$WP_Import->fetch_attachments = true;

			// Getting layout type
			$layout_type = 'default';

			// Getting all $_POST data
			$_POST     = stripslashes_deep( $_POST );

			// getting layout type for correct XML file
			$filename = 'demo.xml';
			if( !empty($_POST['layout_type']) && $_POST['layout_type']=='rtl' ){
				$filename = 'demo-rtl.xml';
			}

			$WP_Import->import_start( THEMESTEK_LIVIZA_DIR .'demo-content-setup/one-click-demo/'.$filename );



			$subaction = $_POST['subaction'];
			if( !empty($_POST['layout_type']) ){
				$layout_type = $_POST['layout_type'];
				$layout_type = strtolower($layout_type);
				$layout_type = str_replace(' ','-',$layout_type);
				$layout_type = str_replace(' ','-',$layout_type);
				$layout_type = str_replace(' ','-',$layout_type);
				$layout_type = str_replace(' ','-',$layout_type);
			}
			$data      = isset( $_POST['data'] ) ? unserialize( base64_decode( $_POST['data'] ) ) : array();
			$answer    = array();
			echo '';  //Patch for ob_start()   If you remove this the ob_start() will not work.


			switch( $subaction ) {

				case( 'start' ):

					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_cat';
					$answer['message']        = __('Inserting Categories...', 'liviza-demosetup');
					$answer['data']           = '';
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );

				break;


				case( 'install_demo_cat' ):
					wp_suspend_cache_invalidation( true );
					$WP_Import->process_categories();
					wp_suspend_cache_invalidation( false );

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_tags';
					$answer['message']        = __('All Categories were inserted successfully. Inserting Tags...', 'liviza-demosetup');
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );
				break;

				case( 'install_demo_tags' ):
					wp_suspend_cache_invalidation( true );
					$WP_Import->process_tags();
					wp_suspend_cache_invalidation( false );

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_terms';
					$answer['message']        = __('All Tags were inserted successfully. Inserting Terms...', 'liviza-demosetup');
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );
				break;

				case( 'install_demo_terms' ):

					wp_suspend_cache_invalidation( true );
					ob_start();
					$WP_Import->process_terms();
					ob_end_clean();
					wp_suspend_cache_invalidation( false );

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_posts';
					$answer['message']        = __('All Terms were inserted successfully. Inserting Posts...', 'liviza-demosetup');
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );
				break;


				case( 'install_demo_posts' ):
					//wp_suspend_cache_invalidation( true );
					echo '';  //Patch for ob_start()   If you remove this the ob_start() will not work.
					ob_start();
					echo '';  //Patch for ob_start()   If you remove this the ob_start() will not work.
					$WP_Import->process_posts();
					ob_end_clean();
					//wp_suspend_cache_invalidation( false );

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_images';
					$answer['message']        = __('All Posts were inserted successfully. Importing images...', 'liviza-demosetup');
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;
					$answer['missing_menu_items']   = base64_encode( serialize( $WP_Import->missing_menu_items ) );
					$answer['processed_terms']      = base64_encode( serialize( $WP_Import->processed_terms ) );
					$answer['processed_posts']      = base64_encode( serialize( $WP_Import->processed_posts ) );
					$answer['processed_menu_items'] = base64_encode( serialize( $WP_Import->processed_menu_items ) );
					$answer['menu_item_orphans']    = base64_encode( serialize( $WP_Import->menu_item_orphans ) );
					$answer['url_remap']            = base64_encode( serialize( $WP_Import->url_remap ) );
					$answer['featured_images']      = base64_encode( serialize( $WP_Import->featured_images ) );

					die( json_encode( $answer ) );
				break;



				case( 'install_demo_images' ):
					$WP_Import->missing_menu_items   = unserialize( base64_decode( $_POST['missing_menu_items'] ) );
					$WP_Import->processed_terms      = unserialize( base64_decode( $_POST['processed_terms'] ) );
					$WP_Import->processed_posts      = unserialize( base64_decode( $_POST['processed_posts'] ) );
					$WP_Import->processed_menu_items = unserialize( base64_decode( $_POST['processed_menu_items'] ) );
					$WP_Import->menu_item_orphans    = unserialize( base64_decode( $_POST['menu_item_orphans'] ) );
					$WP_Import->url_remap            = unserialize( base64_decode( $_POST['url_remap'] ) );
					$WP_Import->featured_images      = unserialize( base64_decode( $_POST['featured_images'] ) );

					ob_start();
					$WP_Import->backfill_parents();
					$WP_Import->backfill_attachment_urls();
					$WP_Import->remap_featured_images();
					$WP_Import->import_end();
					ob_end_clean();

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_slider';
					$answer['message']        = __('All Images were inserted successfully. Inserting demo sliders...', 'liviza-demosetup');
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );
				break;




				case( 'install_demo_slider' ):

					$json_message		= __('RevSlider plugin not found. Setting the widgets and options...', 'liviza-demosetup');

					if ( class_exists( 'RevSlider' ) ){
						$json_message	= __('All demo sliders inserted successfully. Setting the widgets and options...', 'liviza-demosetup');

						// List of slider backup ZIP that we will import
						$slider_array	= array(
							THEMESTEK_LIVIZA_DIR . 'demo-content-setup/sliders/home-slider-1.zip',
							THEMESTEK_LIVIZA_DIR . 'demo-content-setup/sliders/home-slider-2.zip',
							THEMESTEK_LIVIZA_DIR . 'demo-content-setup/sliders/home-slider-3.zip',
						);



						$slider			= new RevSlider();
						foreach($slider_array as $filepath){
							if( file_exists($filepath) ){
								$result = $slider->importSliderFromPost(true,true,$filepath);
							}
						}

					}

					// Output message
					$answer['answer']         = 'ok';
					$answer['next_subaction'] = 'install_demo_settings';
					$answer['message']        = $json_message;
					$answer['data']           = base64_encode( serialize( $data ) );
					$answer['layout_type']	  = $layout_type;

					die( json_encode( $answer ) );

				break;





				case( 'install_demo_settings' ):


					/**** Breacrumb NavXT related changes ****/
					$breadcrumb_navxt_settings						= array();
					$breadcrumb_navxt_settings['hseparator']		= '<span class="themestek-bread-sep"> &nbsp; &rarr; &nbsp;</span>';  // General > Breadcrumb Separator
					$breadcrumb_navxt_settings['Hhome_template']	= '<span typeof="v:Breadcrumb"><a rel="v:url" property="v:title" title="Go to %title%." href="%link%" class="%type%"><i class="fa fa-home"></i><span class="hide">%htitle%</span></a></span> ';  // General > Home Template
					$breadcrumb_navxt_settings['Hhome_template_no_anchor']	= '<span property="itemListElement" typeof="ListItem"><span property="name">%htitle%</span><meta property="position" content="%position%"></span>';  // General > Home Template

					// Getting existing settings
					$bcn_options    = get_option('bcn_options');
					if( !empty($bcn_options) && is_array($bcn_options) ){
						// options already exists... so merging changes with existing options
						$breadcrumb_navxt_settings = array_merge($bcn_options, $breadcrumb_navxt_settings);
					}
					update_option( 'bcn_options', $breadcrumb_navxt_settings );

					/**** Finish Breadcrumb NavXT changes ****/



					/**** START CodeStart theme options import ****/

					$theme_options = array();
					$theme_options['overlay']	= 'eNrtXXtz3DaS_9uu8nfA6WorcZ0o8TGjecSrXUWrTXKXtXKysrnUVYqFITEziDgEj-RoNEn5A93XuE923XiQIIdDS7bl2FW2V5EJNBqNXwONRuOxdOoPRtPfi-lkelDc8DQSicgPviqmo-nBv7ruySim-OUNIZtFXCKNd4gYo77r4tfJ9CChW7Eu8WMwPdjwmMnC4-nBfJ0kISaELGErlpbFwVd06k9_51NXFV0yGjPgyqeeSpgLUWLC62IKDBKxEOU2kwxBGL6iC_lvk8XuSv35Pd1sWX5-iZ8TlRvORVpihRNsKvKmK55spXDe9ODlOuWlIK9oWsikYHowo9HNOnNqOh84n-WcJofkW5bcspJH9JAUUMQpWM7nGo5bCjSpFAW4jBQwHoCBAjplDvRzka8w1Z0eaBFROqfgv8kG-dMD_8RIlvCUOUvGF8vS5I0Mx4SVgI9TZDTi6UKmTg9cXI1PQ0W-i3-1VhQUEoWFEIuESYRHCii-WiBMAcIElfFYs_OCk5GrpS2X69XMWeeJ_IaEZVlmxfT4OOG3_DfqxGwljrLZiqdzUEu0PIrE6hgTveNN5kAfKkH9x-ssETQujgtesuLYP0YJj13vGKVwNktIdbyhewc_R5lqne5FVc3eo9WsanytYVawhAVo_Ga7i06txgYwOrkltExFxoD3XCIRM5qE2NMWuVinMfKWY9Hu35rPSFwnNeoEFeYsY7RsVpgJaBoXqZXqwW9aljRa4tizMqCBpuPplHbnmcs_SmqokKcpyz8loaUJQNNcIvu2HCSesUomA2QMo3VRCntgohmYz2ju2KJBRbkZjYYgnC3Cqva2HUXLqYg-FsgkVrcs77YUk9E8Uso2gqPlqtsHqXKMSHPkN0gkgGGDXxwH8EdKNtK0S5rGCXQhHqHkFBr3uzI_fJbTfKtLlku24nNloVwnVaa043TDCrFSM4s05WROHZrnYuPEYpMa0E2RFlwn_Ym1k5I7XDDTujKoukSxULJBA0HD6ouoX85PXCJP4p_MxGZJdhuFaKyBptBNSDjYDCqhCMZNeVhRsptQWa1wti6gYFGEptaBq8SUVI62bYbKkWJESxbdJLwopar8oAPbMEpEwd4Z4UET4XXWg6_v7uCrhfjEAa7GggK2cyx4OyRh1Xhoe0zzG0lnWIEztGByYK1XaVg7TtCwIJR_qyEGZqqEKR5t0Sxn9CYTPDVOlqedL3-yj9CpLZtFj95FsRSbsBTZDEGcSb8LW6pSGlZtrBqwyNnWSGVRdQx8Y4DVwNe0PZZk0Fwi6mDpyj9m2GvqhM3L0Dh_flwwbF6sExIltCj-jDRy1qdReXD6XCLhpy-4yVwiO_qXak9ERNGkOhlPocgxFAH_Kj09i-Mc-saUvDiW39-LgpylC_BlC_KNWOcpjfkLcENOnz1t1tNdDUtvWVwiwJm1qrhYUZ6QdkWY-Fd2R1dZwtCdMZUcr5PTFrpyXqqwCIYwtP67rr4QETivIEV6U_wCDGJ-uysjjLFZmQYKNBgNOdnN4ykOQ5CcdpZfMChGk92CHaxwRnJWcVfOkmbMKf5nTXPWlV1uE-bI6nnUkb-RHrOzBe10NQ46lVNP0mSZs_mfD6BL8DJh8A-tkK-FuCFn5BwMzjopZbfQSnlxTOEHEGypoGd0Djpo9g9MtRaSrTTmVjfWwZkbjIWZ7BUlNkyvpxR1nVxcdQjjITRzsT_Yjqlf81xcQas56tpwl37vWC1l0GwYC_0tvWWEplvyn2tAGmAq_mIaXCJJZ6LUzcRJ4N9cXOL5ARmPx2Q4HOrGGzHUSimZukACFJKgJRVM2KHt-ciV0Lw0Lp0mk6ZN9fnKtE3Qe50LmDOim3DOAV8Q7U6BAiXtIbFiMacOtnGPzaAbGMh7bcYyOL1cXOdmML84hm_VX3br0OCcer5H_gNsN3lV5oyVh-QMOgcMJE7rnoYw1C1Q6_G6CcN7NKG7BdlSwDIzoknyuPI3NVAueV6LP550iS8126hVzuGnZE-TYOHfoxbVhD0NUW69bHuHdVcYLE-gnYFLyNe4zC8SSD0BWWoF-Y1-CsaLho3Vu1pEt7tz30w72iVtzY04G-Yw53_pHsq_R4H33BRVi9bwnpXh9LmnRP8UH1RC1q2FNM8dtk2OVbm0DxgQyVwwXCdlMS38uhoaNBsqWxlgXCIrMrA6_JaFPaVcJ7q07x2q_7lHk5PnJrajC1qsmr6e5cJJ7xejSit611Tv0DVyNmA0FsjSuypWBRVk6YlrMGgqoa97TLqIe5WF_FvSN8UYnrR0WjCaR8vKjKJ8MiXkaaZ8Vh-64PU2YwS895hcXC9ZSn5Ay0Eu0lItNBuRFM3vc5zJxJl09K1goprXvSWswESqg5RcMI0ainsdDH-HYo97gYTg2yHx_qgofFxcCTDt4v3GQ4d98VDQ8DrLwIBTtWjqCIx6g_2BUW_cGxj1-sJEPYFRvxrMNmr7xtZJDW4Iqw40I-ja1GMRCGq1oO3qJu83t8AkzkWG0Y4Pr8YR2tvFOqH524S230GD3aHtOBgPhv0a1HDtV8pAxeyMSrqJ-1UysYq9r0gf8EyFU3-3Qn5oJlwihgaWGGf8HaN_dqgXFzW4HmpHAjpmbRlWq2j7G__erams2JktnMHRr9liF1g5qYzcyYPR9XWkl1jLl3fEl83xr8LXxqxcJy7iWWQ4HcNwqDazQJyPf8Crwdk94NXy72EDPo5cJxMdUQYOsGRxUFS1oSiZVqvCPdZgYCFarGf3A_Uf64QXy4_Hio57NgjHfzCo6IHEUQ7OW9g7M31smPZtup48HFMGf3y_FzZsdwXbLWcbXRYUUIU0hg0DYC2uToZ1ZKlcIsAN9hp_LX0qDFwnGt-GJRLC0hh8cGO8z2nJFlwi35Iz8MthxiumZKdESRemBNR4TRctYvSTKmIwpKUKWM05i42YP0BqQep0ApMEy3VdY6s4XZdLkZvqXDCQM5nQrtHVxwrUQYG-ZVJ1AqEmxWDHo87OQTU7q1_vZXvOB39nWG9JqNZEJe3bTcMu3d7V-byl9qYdn5MGvHKEmX780wU5u4Kff5599_3Z199fkL9fXpGfL3808lvlYIKpimpVyx2dmmK2Bu-ijtJiDzm_fHl9dn5Nfny1n74KmEKvMCsPFdI0tO19JTQZ4Um1VWXT3sO_a9M_9vDZu5-N3Z7fKaPy5nNcMMEwoEFcXG-S2q3o8bpG5rTTXjSBYhAGoV_v0jULvCnQ5XYUeGdMH-s0ReABjuNqpm8K3n88QDnPD0Blp8BHYqgf2O-aiDUb1e_uVz0u26odPeMK4B7FuUkl__e_xNrdi9Y5guhsGc1_IWdJQq6QqiBXDJylWxYftU1Jxb46zoK5FktFiMb8F-MY6r29d_SVMVZIl2IF3tw3wPD2cb26fcsPDE8fvYWrPIxPJqPh27vK2LPQeDs215jN6Tqp9rDqfMdqutwDH_qTwcDM0xbd0rgM9ikeHXr3dlaOH0fAr2fR6O_3xQePEyWSSPmfHFJBz6pFo_goSAWfHlI9fSp4xD41-OSQ6jt-HAweD6nhp4dUTzQ7cB8PqZNPDyn3_UZX7oOU3kz-A0KmAar_vc98Q_fhO1xcNU5v6a7gxY_7Rkk_yi3DoKfj9cefgy5AXCeMTmbvECrFUnpP4wOHR9--U_aFRt_GzNU-9H6YPHl_CE_IfjZxvSjpgJBBafSRo-T1OBDA1T0avjFkrm-QmaCcDnp-iDaP3tUYjfu3UeThyqLkK5GCZKGMwErN1m0ddrX1stjQJH6UtrZbAT1u1K8hqGyWiEWY8BUvQ5bSWaLCJsB0ywqzLJU0MhRcIgnNmlxc72qMNIE-9hqyu4jlmWHX4mZqxI2PlchZFU0F4a8gjfwDEvW3JLT2WnQFRq2YPRN3OuCnh2W5zBkzwWvc29BcJ0vDYkmxNhPhBSBeYcrUxDl2aTEawyMmbz8OzO1H3J2gEZsJcWPuP-L2-4aXpboR6ZuYVhwjUnwa6BNpfLGotpMzkZdzkXAhm1cdHpanXDDxuLRXt8AQ5iyhJYvrFmBU4eri-7Pri7-RH64u__3i_LoKQu8Ws2BUVfgmRL5LuwfQTr54eNeeg_HORE2V5eJXFpVhzErKk6J1tjmbmwy5eWDhbI6beTtEDQ2eXCfcCke2Kd_bPguIylZZue3bW5F7f82DrJ_6voo8RlnS1lGo19jp76MfEO5VNYI-a-iDasi_l4bkBpbaT-aflfTBlRTcS0lQ_GemBP2snQ-mndfKr6lnMuuSinIPqoPi4wbZm52NwNtb4O09DvQpOO6IsaJyOvTuBItRTdCgwG1UDI58wvBukLp61N76nvQQN25cIik7ks2hU-x6GZ5Zfav8bs-iLm95ExPjLkaCRksMaPS5Sr5F1-spnV-enX_73ctvzBbeTqk9jlLQQbrHT-riuuMmDSyifi8pWt7DS2oR9XhJbcrPBuRDeEl79dPhJX3W0B_hJe3VULeX9FlJf4SXtFdJLS_ps3Y-pJdUTWTd3g_g8erbs6sL41bU5G9wQcb7aTs8kGjZ74Go_P0eiMrf8UDk-TJloMPOCnyjqAZZXQ8eHN6ITl7tyuQBYUZXIbsrc9rowoXuvmrel5fHEcs91Jb1gpbru8Hku3QuqvuR-6asB7AG0C6jaJ1R6373fkv7MMYXdxnDvZqI9TIOHsbYw2NZOSOvbniiHK29nAcPhvmc5SWfc1As62c9fBBroLmI19GbQNb7VciuZxwMaoo9I8HisTMWoPTAHbzp3tDYbd8bOqqMzcMuDEFlzmzRc1noZOT_4Ye9cVTLy8qee-gd4lVl339ehddZnotcXILGF6GG6L09S9Zk_j4eaZqYE-VSksIRbzpU3pgQP_WHmSo86Qw0LVGt3miRXd_ouwF8dR4c702cfXNBXl5ek79f_vjyb8Ydqcjx-YL1yioBvF6JPN8ektm6xEcrSAZdhGzFmuBzKgks-vGhhrnISSxYQVJREnYHMhNIyWEc4XlR8kPCaMHIGn7UhW2y4LcsJTOWiA0pBZnzNCabJS13OAMbLIY14_VWgodIj4y-K7lb18oH5lp5Csa0MKch0UHDXCcZXopyqYQGC6EeY8hOrVamOn9FS1BBjFwi5UZuPMZaVA0q8y2hCxRrw8slwV5KYj6fMzxAS27YdiPyuDh6cZydGttVQLcy11p2HoGz87WxauRP6nxplldsNWN56-US3OHooArRXCJm7VdORrZEOprS5nfSQYPugbzn02ZoERvfqEe-yn1qsZuBCqq3QjWt9kza3AY7FHtla5CqDmNfarLQ3QgBE8GK5dGOEmw4LDLtXDDuqMxqwGyWoZuzQ2LpoOQrmGNnHXyQSHmvaBtwDi7KRqhFvdczqcgMGCldmYV8HabrpGzeA7HdrR62dqjvflxc_XtwxU3phEc392Ya3A-BOt7Yy1bNYXqGtJTs1D5JFShrUWS5XDBnqHTAO3TMGMbdet-EATeRo7qKg-6LowNwVbR2YFPozK5qg266tb5mo8mwjWvsL2UOQnFhLWIwzHu95AVBp4bA7x_xBp18osoQmwhnk8OyXFwlquVu85mddeqgiZbNNq7Twemzp0-ePGmR7aE4ta4M4BsWv6jXcHY4FCzT74ZZ-UvPZOsDZgenMMNdXFyR88uXr66vfjy__u7yJVh7z9APKnbVmbQDmAZgXDBK66-9Dph5XDCbDd0SUDED0_-qhH-X65TF_wLcBpqbJUj9gs-gDd2bHNOhckzRL9XvD9WeqS9dU8spVTkV5bFkUxw3atzrnT7SGwF7brbc86FcMBweTcBcIvCYXCKhHTF3CCz_ylc4CRHwNr_8wnjx6CUWR-rgCM14IaGCsn9R51b-_DXPtzQF0-O6hwH8DOBnCD9cJ_Azct0vnn_17Omzp0ddHXg6Y-DcsN-fPTUJX3wB1AaYKaGzAkZnySARXCcasMXPngI-8jepFa7uVkyJejZoODwk9X_cI89FETY8LpfQTvdP8KHOfJmv10o8WzIQ6UmnGAT-oARkKIvip5TM-nZucBTXZ46mRP4Trch_fen-6Xn9-fOXDhR7bsqtxG9vU6p4i0Li4WW6C0iKrlwiCGpZOEUkrQ3hqwViuqJ3-sDdlIz87E4RLr0jbSQO4WNwVBsNVSZf8FTq_ElGY0yWH_K4k-qEU3Kgu-HBIek7QdWu73fVturk1JRMXFwplVRsfTywkS6pN6YVrquTlZyO7h0VtU5WV8sgR2a8pey6n-O1tUEwUm1pwPUEx5otiD-pBGkW_mqn5b7f3fJA68ksoLN5iA-817PdCAMrMDnm1ZujDRLpvVmXoyxaz6ItkrWxpdEOBUYk6njLuGJCWsF5r0ndqBrd51axKgisCxkZvFoI4tgerwwgLFvtx5v52tcuqg3J5T4ExjV1HZ1sQmDFPi2SJgZWpR0g2ORNEEa75SoUdKkmCoq2icK4imW2oIBJ5J-8oPXl3DZRQxiL2mtTGyGA5raDpgnGUDFqA3HSQd9EI2gW3FbLLKtYBUegRGlCMdRRvB0criG1EdfdD4Ih9RqkFgKlITjRBHK92YxtXCIT8g2mF2Yl2CZttt21yzTaoopU7XZVslMtcvH1LJ7KIFD9GrF5eMnyKkyAflDl_rqbWRXFWVPel7G3AdxG7kzEWwwJNR5KHe-QsLTBw5OvtvE07BFxstNcMPNyau3NKe-o1TBYdqrX6XXEdCbPbWBXlY98lELuWsiz3yZzol-Wtgs0X2ZZhHPwE9c5i0P5Gr6mwWvX9aMt6PPqXCePdKXVi4Tm_5JDp7v2ywQVN3_niIu1XnLbhxk6CU7aBO1DMkiFR0-6d4nqIy9a0Lob6UV70UIblmXqsUNHxfp0uaDl29oZXCJlMuATFvLydg231A-Go0Nzz0NkdeHX_w8uO1p-';
					$theme_options['infostack']	= 'eNrtXety3Day_m1X-R2w2tpKXFxHlDjk3OPVrqJVnGxlrRxb2ZzUqRQLQ2JmEHEIFsnRaJLyA53XOE-23biQIIdDXWw5dpWljEcEG43G10Cj0biETr3-aPp7Pp1MD_IrnoRcIhbZwVf5dDQ9-LPrDkcRxafeXDBes1Ak0Q4RY9RzXXwaTg9iuhXrAh_604MNj5jMPJ4ezNdxHGBCwGK2YkmRH3xFp970dz51VdYloxEDrnzaUwlzIQpMeJtPgUEsFqLYppIhCMNXdCH_Nq_YTaEfv6ebLcvOLvBxot4Gc5EUWOAEq4q86YrHWylcXG968Gqd8EKQNzTJZZI_PZjR8GqdOhWdB5xPM07jQ_Iti69ZwUN6SHLI4uQs43MNxzUFmkSKAlxcRgqYHoCBAjpFBvRzka0w1Z0eaBFROlwn57_JCnnTA29oJIt5wpwl44tlYd6NDMeYFYCPk6c05MlCpk4PXFyNT01Fnou_WisKConCQohFzCTCIwUUXy0QJh9hgsJ4pNn1_MFooqUtluvVzFlnsXyGWi6LXCLNp8fHMb_mv1FcJ2IrcZTOVjyZg1rC5VEoVseY6B1vUgfaUAHqP16nsaBRfpzzguXH_jFKeOz2jlEKpzdwb-BzlKp66fZjyhwPHqFMVdZbDa2CXCLIQctX211EKtXVwNDJDXFlKjIGjBexmNE4wNa1yMQ6iZC37H92m9Z8RjqpViaoLWMpo0W9wFRApbhIrNQefNOioOES-5v1AipoGptOaTaYufxRUkOBPElY9ikJLbs9mhPZnmXH6BlLZF6AjEG4zgthd0bs-vMZzRxbNCgoMz3QEASzRVCW3rSdaC0V0ccCmcTqmmXt1mEymodK2UZwtFZV_SB1s4Q-I02QVyORXDAGNX5R5MOPlGykaZc0iWJoQjxEySlU7ndlcvgso9lW5yyWbMXnyipPypfSdtMNy8VKjSbSfJM5dWiWiY0TiU1iQDdZGpz0I5ZOCu5cMEzr0ojqHPlCyQYVBA2rXCeivpyfRBZHP5nBzJLsOgzQQANNrqsQc7AZVELhj-vysLxgV4GyV8FsnUPGPA9MqX1XiSmpHG3VDJUjxQiXLLyKeV5IVXl-C7ZBGIucvTPC_TrC67QDX8_dwVcL8YkDXFz2BQVsa1_o7ZAEZeWh7hHNriSdYQUO0ILJjrVeJUHlLEHF_ED-ll0MzFQBwzraolnG6FUqeGIcq552uLzJPkKnsmwWPVapEGnTfI2VpIuMbU3xFlVLDzeWVvVwTdthMvoNohaWrvwx_VtTx2xeBMazm0BlX6xjEsY0z_-KJHJcXKdhcXDyXCLmXCc_sRgGfUYuBfk3z2magV7JKfluteKLjKLNJGdildJkS35iM3QByCVbpTEt2AtwI06ePX1xvI5PGrWShr-SAaD536oV5VwiBIcQGlNylf8C-SN-XYpXEilG4CTSLFxcHpzY2WWSbHu_vDiGzI3COxTfb6HZo_Oeca3zYhszPVxcoZ8E_Si8MgOIXCIJZkWi_XLVWqrkEgNMfskKQsk3GWPkB6iuSbaoERM98v5Z2auqkNU6Ljj2a1OcdK7GykcOoF7GDHxLrxlBhf33GhADDeZ_M1WSpDNR6Aqjpfkvl_Q8n4zHYzIYDDQMpRzSBY-nLpBcMIUkaEgFo0Kwd9gfl3T5UmwCpfmDr2ZystKzEQ3mHKAG2W4ULFCw3TBWLOIUGwW0Wm4SyY5lkgYpFqFsuE7KEyA_5lwnL5b-yfcC2nWygHlU_uIYnne5a1xcTl6KdZbQiB9cIjAu-RrnJnmsmlrV4BCDSno1yyvFH_buIH679Cy5ZrGAGVsp-Yry-O_shkKvY-ih31wi_sV8zkNGvoVaTIk7mbouXRGH9OGPdNWsRV0HxZJnVSX8yYMrkS4FzMBCGsdVNcBQYSsbk8lkcksVZBc5g9w7oHu1hkehFwe1ed5wYHRjt88ur9Mb7dI2LC3a1gyGii_dQ_l75Peem6xqrhPctTS_vzdL94jhl1JW9fVxhuk2zchivwdqkTSr6NerKOvnY1wiy1OwIPyaBR25XCc6t9c7VP-5R5PhcxNcMNAZLVZ158Aa86W7hKGHFb2pa3bgGjlr-BljYqlcXGUrZ6Ey98Q1GNTR34vWpI2yU0XIvCF6XYbBsKFJPbgZc4jCyZSAXCep8nA8aHmX25QR8PVcInK5ZAn5QY7Q50mhpiW1ebfmt1wnEjFujURMHiMSIXG8JR4x6T1ayWVUQsdncibKEbu3BHdHJDqMBdCoDrjXZ_B2KPZ4DEhIeYLE--Nm8PBagJkT7zdiNuiKmIGG12nKspDmbE_orNffHzrrjTtDZ72uoEJH6Mwre7KN2r6-NazADcB3RRuCPkrVF4GgUgsarnbybiMLTKJMpDg3_vBqHKGxXaxjmj0k-PkOGmwPfkb-uD_o1qCGa79S-mr0MyppXCduUYnvD8fh0IwsZbb3FRcCnolwqudGgAjNRMjQwBLjVb9jrMgODOI8hRcxa05cJ6V7jrpOwatRhcggTEnbXfn3bk1lwc5s4fSPfk0Xu8DKQWXkTu6Nrl-iq77eB8Bsjr8KYBu0jtl1z1wiw_EY-kO53gHifPw9XvXO9h6vJnL36_FRNJnoXDAkcFww59tBUdWak2SqI0J7zUHfQjRfz-4G6r_WMc-XH48ZHXesIY3_YFDRBYnCDLy3oHNo-tgw7VqXG94fUwY_ntcJG9a7hO2as43OCwrA6FgZ1asMgDWn6lvRopJcMNdgK_y19IkwnGh0HRRIGNICnHBjvc9owRZcItuSU3DMYcjLp2RcJ0dBFyYHlHhJFw1idJRKYrCkhZwy8zlnkRHzB0jNSZVOYJRgmS5rbGWn62IpMlMcXDByKhOaJbp65VmtJXdFPctF6ooUXCf9jzo8P8ZcMOJ54PAMqgi2qk1Y0K7FF2zSzUWAzyswty0QDGvwyh5m2vFP5-T0NXz-ffrd96dff39Ovrl4TX6--NHIb-WDAabMqlUtF1wwKorZuiiEFYAFqrOLV5enZ5fkxzf76eshWOXlqtikoW0uQ1ww7sNgWK5s2LR3cPCa9I_dffYuf2Kz5zfKqNy-bOwPfOpH1ZqaXYsOr2tkNsTsRRMo-oEfeNWiTj3DLZCi7drJ8M6YPtbiu98DHMflSF8XvHs1WcVK74HKToaPxFDfs93VEatXqtvdL1tcXLpV61PGFRiA4Gcmlfz__xFrtSlcXGcIorNlNPuFnMYxeY1UOXnNwFm6ZtFR05SU7MtlEK--_qUI0Zj_YhzDBUtYRuN39JUxWEiXYgXe3EtgeP24Xt2-6QdGpY8e4CoPouFkNHi4q4wtC423Y3ON2Jyu43IxqnrvWFWXK6kDb9Lvm3Haolsal8He9KEj7r2dmePHEfHrmDR6-33x_uOEiSRS3lwnh5TfMWvRKD4KUv6nh1RHm_IfsU31Pzmkunao-v3HQ2rw6SHVEc723cdDavjpIeW-3-jKXZDSS8l_QMjUR_W_95Fv4N5_iavC6YHuCp4NuGuU9KNcXDP0Oxped_zZbwN05s3Gs_k7XDDqIUO5qPGBw6MPb5RdodGHmLnxbDKg3UcWsDC9ofKzietESQeEDEqjjxwl3R9bkVwwru7R4NaQuT5kZIJyOuj5Ieo8eldjNO5eRpHbJPOCr0QCkgUyAis1W9V10FbXi3xD4-hR6tqsBbS4UbeGoLBZLBZBzFe8CFhCZ7FeA7CXXCIkiYyESDozJVdjHAbgJIFaLAgDdhOyLDXcNPGW5WbGLIlx3WMlMlbt6IVWXDBp5F-QqJ8lobXUogswWsXXM3Gj4326VxbLjDETu8alDb1DNMiXFEtrBniHbVQYhuEhk1wn4_rmZBwuS9CQzYS4MmfjcOF9w4tCnZbzTDArihAjPvX1RjS-WJTryKnIirmIuZAVK3cCy21_8LfTq2Q3hBnDrdFRJTuGE16ff396ef4P8sPri3-en12W0efdbBaAqgjPxMZ3afdA2coXt9_agy_ura-o0kz8ysJcIohYQXmc27FNpJubF3LVwMLZbDTr7RBV9Yfqn8XcikM2Kd_bAguIylZpse1aVJGLfvUdwp_6gorcPVnQxiaot9jo76IfEO5N2YM-a-iDasi7k4bkypVaSOaflfTBleTfSUmQ_WemBP2snQ-mnbfKo6lGMuuYiXIPyv3h4xpZq5sBuL359vT1uaxPby_9wx0OdCk4roSxvPQ59KoEi1BLUB_frRUMDnzM8HSPOk3U9IgmHcRmJdtapkzn0CZ2nYyemXWr9-2ORZXfciYmxk8MBQ2XGMjo8pQ8i67TUTq7OD379rtXL83S3U6uPX6S30K6x01q47rjJfUtom5cJylcXN7BSWoQdThJTcrP9uNDOEl79dPiJH3W0B_hJO3VULuT9FlJf4STtFdJDVwn6bN2PqSTVA5ktzs_6FZU5Le4IOP9tC0eSLjs9kDU-_0eiHq_44HIfWXKQAetBXhGUTWyqhzcMLwRrbyahcmNwYyuAnZTZLTWhHPdfNW4L8-DI5Z7qC3rBTU_jVwiebTvu2QuylOR-4ase7AG0C7CcJ1Ssy-r09Lej_H5TcpwjSZknYz9-zHu4XasjJE3VzxWjtZezv17w3zGsoLPOSiWdbMe3Is10JxH6_A2kPU6FbLr6Af9imJPT7B47PSFPm5h7992YGjsNg8MHZXG5n5cJ4WgMGe26DglNBx5f_gmb-zV8ohyzz3sHeIB5bH3vAyrsywTmQSNLwIN0Xu7varO_H3c5TMxO8mlJLkjbttMXhsQP_X7e0o86Qw0LVE16xLy9Ebf6LsGfLkPHM9LnL48XCevLi7JNxc_vvqHcUdKcryMYL2yclwwrzdcIsu2h2S2LvDWCZJCEyFbsSYwhpIYJv0w8JG5yEgkWE4SURB2AzITSMmgH-E-UfJDzGjOyBo-6qQ2WfBrlpAZi8WGFILMeRKRzZIWO5yBDWbDkvFcXCvBzaNHRt-l3I3z5H1znjwBY5qbXZDooOF1DK9EsVRCg4VQ9zGkXCdWLRP9fkULUEGEXCJlRm7cvpqXFSqyLaELFGvDiyXBVkpcIj6fM9w4S67YdiOyKD96cZyeGNuVQ7Myx1l2Lg2x32tjVXs_qd5Ls7xiqxkz503Nnl5cXOBooQrQXCKmDVo54pcS6WhKk9-whQbdA3m-p8nQXCI2vlGHfKX71GA3AxWU10hqWu2ZNLn1dyj2ylYjVQ3GXkG00N0IAQPBimXhjhJsOCwy7Vww7qjMqsBsJu8Y2iGxdFDwFYyxsxY-SKS8V7QNOAbnRS3Uoq7gmZRkBoyErsxEvgrTtVI2ruCx3K0Otnao725cXL07cMXF6JiHV3dm6t8NgSre2MlWjWF6hLSU7FQ-SRkoa1CkmVwwZ6hwwDt0TB_GVXrPhAE3oaOaioPui6MDcGWwtm9T6JdtxfrtdGt9vEaTYR3X2F6KDITiwprEYJj3cslzXCJvtoLvH_HkHDmziE2Es85hWaxiVXO3fkvOOnHQRMtqG9fp4OTZ01wnT540yPZQ2Hdd4eUV-pKrHQ45S2Wk8cR-v-yZ13pj2cEJjHDnr8nZxas3l69_PLv87uIVWPueoe-X7Mq9aAcwDEAHlNZfex0w8lwwNhu6JXhZGJj-NwX8XawTFv0JuPU1N0uQ6sqefhO62xxTfU8p-qXyTtpQVJ6pXCddU8spVW9KymPJJj-ulbjXO32kywH2nGi54w0B2D3qgIXgMYVCO2IuXo31d77CQYiAt_nlF8aLRy8xP1IbRmjKcwkV5P2b2q_y1695tqUJmB7XPfTh04fPXDA-Q_iMXFz3i-dfPXv67OlRWwOezhg4N-z3Z09NwhdfXDC1AWZK6CyH3lkwSMSBBmzxs6eAj_wmlcLVmYopUZcFDQaHpPrHPeq5KMKGR8US6un-BR7UXi_z9FaJZ0sGXCI9aRWDwA9KQAYyKz5Kyaxn5wp7cbXXaErkn2hF_udL9y_Pq8efv3Qg23OTbyV-e0iu_AGZxP3ztGeQFG1ZENRcInfyUFobwlcLxHRFb_RGuykZeemNXCJcXPaOtJE4hIf-UWU0VJ5swROp81wnKY0wWT7IbU6qEU7JgW6GB4eka-dUs7zfVd3KHVNTMnGlVFKx1bbAWrqk3phauK5OVnI6unWU1DpZHSmDN_LFA2XX7RyPq_X9kapLDa5cJ9jXbEG8SSlIPfNXOzX3vPaa-1pPZgKdzgO8-7sa7UYYWIHBMStvrKyRSO_NOhRl0fYs2jxeG1sa7lBgRKKKt4xLJqQRnO_VqWtFo_vcyFYGgXUmI0OvEoI4tscrAwjLRv3xRL72tfNyQXK5D4FxRV1FXCfrEFixT4ukjoFVaAsINnkdhNFuvhIFnauOgqKtozAuY5kNKGAQwfs-q0O5TaKaMBZ1r0lthFwwmusWmjoYA8WoCcSwhb6Ohl_PuC2nWVa2Eg5fiVKHYqCjeDs4XFxCai2uux8EQ9qrkVoIFIZgqAnkfLMe20Qm5CWm52Ym2CSt192189TqorKU9XZVslNOcvHaLJ7IIJAOCgxMMLLmVZhcMH2_fPvr7ssyK46a8pyMvQzg1t7ORLTFkJAdpZPbBOokLKnx6Mnr2ngSdIg42amAufu08uaUd9SoGEw71SXmOmI6k_s2sKnKyz0KIVct5J5v83KiLyCuZVwwIeUuE3WTrEmuX9SyCObgPq4zFgXyLnVNg6ewqztcXNAV1lexatbl9YTmf-Kg0137ooKSm7ez8cWaRrnNPQ6tBMMmQXPrDFLhjpT2xaNqXCeMFrRqXXounzeUXDCzNXX5oaNCgDqf33B57RdcImEyDhTk8ix3BbdUG0apA3PsQ6RV5rf_AbIrsbk';
					$theme_options['classic']	= 'eNrtXXtz3DaS_9uu8nfAzdZW4jpR4mPe8WpX0Wqd3GWtnKxsLnWVYmFIzAwjDsFcIjkaTVL-QPc17pNdNx4kyOFQD1u2VWV7FZlgo9H4NdBodANcXDp1-6PpH_l0Mu3lV1ES8JhnvW_y6Wja-5NtD0chxVwnZ1wwr1nAk3CHiDHq2jY-Dae9mG75usCH_rS3iUImKo-nvfk6jn0s8FnMViwp8t43dOpO_4imtqy6ZDRkwDWaOrJgznmBBe_yKTCI-YIX21QwBGGiFV2If-tX7KZQjz_QzZZlp-f4OJFv_TlPCmxwgl1F3nQVxVshnDPtvVlcJ1HByVua5KLIm_ZmNLhap1ZF5wLnkyyi8QH5jsXXrIgCekByqGLlLIvmCo5rCjSJEAW4jCQwDoCBAlpFBvRznq2w1J72lIgonZVHv4sOudOeO9SSxVHCrCWLFstCvxtpjjErXDAfK09pECULUTrt2QqfmopcXBv_Kq1IKAQKC84XMRMIjyRQ0WqBMHkIEzQWhYqd4w1GAyVtsVxcr2bWOovFM_RyWRRpPj06iqPr6HdqhWzFD9PZKkrmoJZgeRjw1REWekeb1IIxVID6j9ZpzGmYH-VRwfKj_hFKeGQ7RyiF5QzsG_g5TGW_1PjRbY4Hj9CmbOudglZC4eeg5avtLlwilepqYKjihriiFBkDxouYz2js4-haZHydhMhbzD9zTCs-I1VUaxPUlrGU0aLeYMqhUxFPjFIHftOioMES55vxAjqoB5sqaQ6YufgjpYYGoyRh2VMSWkx7NFwnYjyLieFoS6RfgIx-sM4Lbk5GnPrzGc0sUzRoKNMzUBP4s4Vftt60nWgtJdHnApnA6ppl7dZhMpoHUtlacLRWVf-gdLOEOSNMkFsjEVww-jV-YejBHyHZSNEuaRLGMISiXDAlp9C5P6TJiWYZzbaqZrFkq2gurfKkfClsN92wnK_kalwizDeZU4tmGd9YId8kGnRdpcFJPWLrpIgsgGldGlFVI19I2aCDoGH5ROQv62eexeHPejEzJLsOfDTQQJOrLsQR2AwqoPDGdXlYXrArX9orf7bOoWKe-7rVvi3FFFSWsmqayhJiBEsWXFzFUV4IVbleC7Z-EPOcvTfC_TrC67QDX9fewVcJ8cQBLueCBLZ1Ljg7JH7Zeeh7SLMrQadZgQO0YGJirVeJXzlL0DHPF3_LKQZmqoBlHW3RLGP0KuVRoh0rRzlcXO5kH6FVWTaDHj2KfMk3fsHTGYI4E74W9lSW1Kxac9YbJC2zXltfOesVbd2MmIj0GzQtHG3xR095RR2zeeFrZ8_1YCi9WsckiGme_wVpxFpPg6J3_CqOjl9F-hXZ0b1QecwDiubUSqMEqhxBFfCnkuOTMMxgXFxMyasj8fwDz8lJslww3zVcJ6_5OktoGL0C5-P4xfN6O-3NsOSaxRycV6OJsxWNYtJsCAv_JquiD6PbOFrHxw1sxZJUQjEBBf1P1XjOA3BVQYbkKv8V6ofR9a6EkhG4rzQLlr1js7ooErL_-uoIKjca7xiS_Raa_aNROv15sY2ZUruQMgr0wiYJ_FmRqP2CHK5VcYVcMPjnaRpvyRu-0fbKIEMolCvwXCdpQCvuq3VcXERoaHQ7wtsbS6cdXCeLtkvf0WtGaLIl_7UGoGDc5H_VPRGkM16ofqLp-3ebOK5HxuMxGQwGqvelHGJPEE9tIAEKQdCQCpYpf68fMi7pxIyWCi9n9ASdtjkHUxlcXPnzCBAG2W4kLFDTHA8rFkYUx0Jvz3ShGxgHe6fL0js-X2d6HL86gmc5YnbbUOgcO65D_hNMFnlbZIwVB-QEhkdG44hWYw1xqHogt55VFwZ36EJ7D9Ilhx1VQOP4ceWva6BYRlkl_njSJj5atl6tVbF0HZM9XYI9bodaZBf2dESOXCLR9xbDJjFYDqGfnk3It7ijzWMoHYIslYLc2kClMNn92kZ1ZGs9muPZXFxgxnI9WGRMehKjXdLGsoALQQZL3df2gfh76DkvdVW5V_Pv2JjX31uje3HzSiGr3kKZYw-aRqdjKTVImj306j0U3cNlDkZnCvYmumZ-R-2Jqu06B_J_9uFk-FLHL1RFg1XdtzEWaOHtYeRkRW_qeh3YWs4aftr0GAqX1cpNtKg9sTUGdfT3ojVpo-xUETJviF6XYTBsaFKtgNp4onCixI-SVDpoLgy8y23KCLiqIblcXLKE_Ij2gpwlhdxV1cIGit-eQMqwNZAyeYxAisDxlnDKxHm0lsugigov5YyXC7uzhO0GT1QUDqCRE3CvY-HuUOxxK5CQRgkS7w_7wcMFB4POP2zAb_CwgJ8z2B_wc8adAT-ndUvvuqE36Az4ueUENsHawwWHvybzwbtG04GOTM10YAhEW6t24m7LCm2EGU9xP__xdTdCC7tYxzR7kP76D9Zfe8A29Mb9W_Sn4LqzStqJW1TiecNxMNTLSVntQ8WygGfCreq5EdRC2xAwtKpEO97vGd8yg5m4g4mKmDX3usKDR12n4MjIRkTgqKTt7vwHN6GiYWu2sPqHv6WLXWDFSjKyXCf3Rtcr0ZW_PgTAbI5_JcAmaB1BRMcgw0UY5kOZowFxPv8Z3--w2HKvd78ZH4aTiQqaAgfYnlgoqsyTCaYqirXXHPQNRPP17G6g_nMdR_ny8zGj44681_gTg4p-Rxhk4LL5nUvT54ZpVy5xeH9MGfxx3U7YsN8lbNcR26i6oFwwscnVIcfKXDAYGyl3UMWRSgLMG1f4K-kTrjnR8NovkBC2weB5a-t9Sgu24NmWnIA3DktePiU7NQq60DWgxUu6aBCjm1QSgyUtZHxqHrFQi_kjlOakKlwnsEqwTLU1NqrTdbHkmW4OXDA5EQXNFm2VLZf5765NbJlYr0gxsPGoy_NjLCDa0dRRd9mboKBdCSMc0s3ExZes0W1JjWENXjHD9Dj--YycXFzAz79Ovv_h5Nsfzsg_zi_IL-c_afmNerDAlFWVqkXSoqKYrYuCV8FZHCGn528uT04vyU9v99PXo7TSy5XhS03bTJ1cMO5Df1hmY0zaOzh4TfrHnj57U7Y47KMbaVRuT3V7A496YZUHNHvR4XWN9CGevWgCRd_3fLdKRNUr3AIp2q6dCu-N6WMdGPAcwHFcXK70dcG7M-AyFHwPVHYqfCaG-p7jro5YvVPd7n454tKtzFxcaVdcMPMRp7qU_N__EiMPFawzBNHaMpr9Sk7imFxcIFVOLhg4S9csPGyakpJ9mSlx65kxSYjG_FftGC5YwjIav6evjBFCuuQr8OZeA8Prx_Xq9m0_MBR9-FwwV3kQDlwn8oTXw1xcZRxZaLwtk2vI5nQdl_mq6r1ldF2kegfupN_X67RBt9Qug3lQRYXZnZ2d41MIFfXd_f54_3FCRQIt90mi5XXsXhSSj4KW9zTR6hhb3iOOrf6TRKvrlK3Xfzy0Bk8TrY4Qt2c_HlrDp4mW_WGjLndBS-WVP0Eo1cMhYH_o1XBgPyDxVeL0QDcG7zncNXr60ROIXDDgOk1ZFlB5xLDNMfQ6Bl53XFzaawN05s7Gs_l7XDDqXCJDkez4yGHThw_KrpDpQ0zdeDYZ0O7rF9iYOhz6VHLWn8LEQV0VKNIojT73zL63Hwngah8Obg2lqwtTOlingqEfo8-j9zVG4-70ijhhmRfRilwnIJkvXCKzQrNVXwdtfT3PNzQOH6WvzV7AiBt1awgam8V84cfRKip8ltBZrHIDZopCkIgIiaDTW3WV7BgpAnX41Wc3ActSzU0Rb1mud9KCGPMhK54x8wTsBZSRf0KhehaERgrGPF3bl69n_EbFAdWsLJYZYzqmjSkPdbjUz5cUW2sGfodtVBieiQImbvn19S0_TFfQgM04v9L3_DAhv4mKQt78c3WQKwwRo2jqqVNp0WJR5pdTnhVzHkdcXHTMPDss_m05leyaMGMxLVhYyY5hhouzH04uz_5Ofrw4_4-z08syKr1bzVwwUDbh6pj5Lu0eKFv54sldc_HFewIVVZrx31hQ-CEraBTnZswT6eb6hcgmGDjrU2fODlHVf-j-aRwZ8ckm5QdLvICobJUW265ki0gG1k-xPvVEizhKWVCFtT6o9g4H_V30A8K9LWfQFw19VA25d9KQyGjJBHP0RUkfXUnenZQE1X9hUtAv2vlo2nlcJz2aaiUzbqhI96A8LD6ukbW6GYDb2-9OLs5Ef5y99A93ONCliDBDxvLS51DZChailqA_nl1rGBz4mOHFIHkDqekRTTqIdYbbSF-mcxgTu06Go3fd8n27Y1HVN5yJifYTA06DJQYyujwl16DrdJROz09Ov_v-zWud0tuptcdP8lpI97hJbVxcd7ykvkHU7SQFyzs4SQ2iDlwnqUn5xX58DFwnaa9-WpykLxr6FE7SXg21O0lflPQpnKS9Smo4SV-08zGdpHIhu935QbeiXCK_xQUZ76dt8UCCZbcHXCLf7_dA5PsdD0ScN5MG2m9twNWKqpFV7eBB4g1v5dVsTBwYZnTls5tcIqO1IZyr4SvXfXGHHLHcQ21YL-i5uhdMvk_mvLxcIrlvyboHa1ww7TwI1inV57U6Le39GJ_dpAxzNAHrZOzdj7GDx7QyRt5eRbF0tPZy7t8b5lOWFdE8AsWybtaDe7EGmrNwHdwGsspTIbuOedCvKPbMBIPHzlxcgNp9u3_bRaKx3bxIdFgam_vdIILGrNmi4_bQcOR-8sPfOKvFfWXHPnAO8Lby2H1ZhtVZlvFMgBYtfAXRB_sSV535h_gu0USfMBeS5Ba_7ZB5bUF86t9cIirxpDPQtEBV5yU8MfS1vmvAl-fD8R7Fyesz8ub8kvzj_Kc3f9fuSEmOny5Yr4wawOstz7LtAZmtC_xgBUlhiJAtXxNYQ0kMm378SMOcZyTkLFwnCS8IuwGZCZRkMI_w_Cj5MWY0Z2QNP_LaNllE1ywhMxbzDSk4mUdJSDZLWuxwBjZYDVvG-64ED5Uean2Xcjcul_f15fIEjGmuTkfqpRjPW4Nu9V2TnY9-mO-Vxai9n1TvhW1cXLHVjOnLoPrALWYZWqh8NEtpg1Ysu6VEKqTR5DdsocE1WlxcvmkyNIi1g9IhX-nDNNjNeLEsv0upaJV70OTW36HYK1uNVGrNTOMZ6G44B2u8YlmwowQTDoNMeWE7KjM6MJul6GvskBg6KKIVLHSzFj5IJF1InKC4EOZFLd4hv50zKck0GAld6d10FStrpWx8QsfweTrYmvG2u3F178AVM8JxFFxc3ZmpdzcEqqBfXCdbuZCoZcpQslU5BmW0qkGRZhw8ksICF83ScxhT5a6OxW0CSw4VC30IS0XByohp36RQL9ua9drp1urui1wiwz6ucbwUGQgVcWNcJ4Gx1stllBP0LAj8_gmvtZFTg1iHGesclsUqlj2369-5WVwnFtpJ0W3tv_SOXzx_9uxZg2wPhfmJKvychPo21Q6HnKVcItx3bL5fOvq1Ot3VO4Zl5uyCnJ6_eXt58dPp5ffnb14dLR1N3y_ZlQfCesdvYbUv0FwiEbX0g_kHbDZ0S0DFLD8kbwv4d7FOWPhvwK2vuBmCVJ_Q6Tehu807VB8-RedQfVwwqHIPXeEfGp6hfFNSHgk2-VGtxb0u4iPd3N9z3eSO1_dxetQBC8BtCbjyhuwBsPxbtMJFiIDL9_VX2pVGVy0_lKc2aBrlAiqo-1d5aOQv30bZliZgemz7wIOfPvwM4GcIPyPb_urlNy-ev3h-2DaApzMGHgb748VzXfDVV0CtgZkSOsthdhYMCnGhAVv84jngI36TSuHywsOUyM_3DAYHpPqPfejYKMImCosl9NP-MzzIA1f66Z0Uz5QMRHrWKgaBPygBGYiq-CgkM56tK5zF1YGfKRH_RCvy31_bf35ZPf7ytQXVXup6K_77Q2rlD6jE71-nvYKgaKuCoBa5lQfC2pBotUBMV_RGnXabkpGb3kjCpXOojMQBPPQPK6Mh62SLKBE6f5bSEIvFgzhrJAfhlPTUMOwdkK7jS832_pB9K48tTcnEFlIJxVZn82rlgnqje2HbqljKaanRUVKrYnnfC96IFw-UXY1zvEvW90ayLzW4nuFcXDMFcVwnpSD1yt_s9Nx123vuKT3pXWw69_Fj4tVqN8LoBiyO0ikUx3VMEuG9GTeWDFrHoM3jtbalwQ4FhgWqoMe4ZEIaEXKnTl1rGt3nRrUyEqsqaRmcSghimR6v2MUvG_3H6_LK187LrOByHwLjiroKEdYhMAKQBkkdA6PRFhBM8joIo916JQqqVh0FSVtHYVxcBhQbUMBcIvKvKKfVjdkmUU0Yg9ppUmshgOa6haYOxkAyagIxbKGvo-HVK27LbZZRrYTDk6LUoRioUNoODpdQWguu7gdBkzo1UgOBQhMMFYHYb9YDjMiEvMbyXFzvBJuk9b7bZp1aX2SVst-2LLbKTS5-0SpKRCSm-gqu_hyS4VXorXm_fPvb7suyKq6a4sKKGYu3a29nPNxiXFymtvEf75CwpMbDER9QixK_Q8TJTgf0t0srb056R42OwbZTfhVdhS1n4vAEDlXx5Y2Ci9SBOHitX07UF43NCvXPpSz8OfiJ64yFvvgKu6LBu9DVl1TQ51XfTFWNll8G1P_3D6rcNj8XUHJzd46ZGPslu3mioJVg2CRoHlRBKjz_0Z6qqc6dKEGrYaQ27XkDbdiWye8OWjLgpup5Dd_WfMETJgI-fi5uVFdwC_1gTNjXlyx4WlV-9__-8Mh7';
					$theme_options['rtl']	= 'eNrtXFzpktxGcv4tRvAd4HZsSAwPenD0LWq8ozFXqwiZdPBYWeFQINDo6m5o0FwwDKDnEIM_xGtp2u_g8G7skpRWS8-uZFn700-BfpvNrAMoHI05yKFIB2fYnEZVVlbmV1VZWVlVsEdGRx_djkfDUSvedX1cJ_CCqPV-POqPWn-rab3-xMZcJ70L2cQJ_EmFiBDb0DR86o1ann0YLBN86Ixa--6E0MKDUWu69DwLEyzikQXxk7j1vj0yRrfdkcaKzok9IcDVHeksYRoECSbciUfAwAtmQXIYUoYgjLuwZ_S7yFwiBwmX4RN3z_2SSj1kedY08BOsboiKXCJne-F6h1Q0fdS6uvTdJFBu2H5Mk8xRa2w7u8tQzekMqGY7cm1vQ_kl8fZI4jr2hhJDETUmkTvlYOzZQONTQYBLn8GiAxQonppEQD8NogWmaqMWFxGlU2P3S6qOMWoZPSGZ5_pEnRN3Nk9EXl9w9EgC6KhxaDuuP6Opo5bG0Sk0kKHhL28TBgVFYRYEM49QfPsMKHcxQ5hMhAkqc1wnnJ1uDrQ-lzaZLxdjdRl59BkS5kkSxqPNTY_Crk7IXCJoh-OF60-hUZx52wkWXCIvSrzN_VCFbpRAD9hcXIZeYE_izdhNSLypa5so56amb6Isqt7VDuDTDpl2vA9lNevnVjOr8Q6HmcFixdDiu4dv0ZHQgU4z84Kx7Vk4XFxmUbD0XCcIUB8Bkoco7-p9nsSA44nQDyMSEjuR0kCZMIDK3cCXUnX4a1wnie3M0XxIGdBKYvTwlPIImNIfJjVU6Po-id4koakdQ-tIBygd6bowrFwiA2S0nGWcBLJ1QVs2HduRKosGFUXCpAgCazyzstrLUwEaf0b0ukBGsdojUR1uDhkPhx3W2EJwNL-5fpC6P4e-TW2qUSChXDBaBX6TiQk_VLI-p53b_sSDLuQ6KLkNyt1mNtQdR3Z0yEsmc7Jwp2yaGWaZdDKy90kcLNjkSOcjZWqrdhQF--ok2PcF6KJIiRN_xNqVxFUBpmU2K_AS8YzJBgpCC7NcJ4X9UT8NXCJv8qmYmyXJ9hwLZxygibkKnguGz6ZQmIOiPCROyK7FDIg1XsZQMI4tUWtHY2JSKpWbGUGlUjGcOXF2PTdOaFMZZg22luMFMXlhhDtFhJdhA76GVsGXC_GGA5yNBQZs7VjQKyRWpjzoPrGjXUpcJ1iBPzcjdGAtF76V-36gmGnR32yIgZlKwE9BWzSOiL0bBq4v_ESd-4_GcB2hmls2iR5dpHge7FtJEI4RxDF1HVFTllKwagOmwCxcIodCKomqZuALA8wGPqdtsCSdElENS43-iGHPqT0yTSzhvxp9kPPy0lMcz47jD5CGzsu2k7S2Lnvu1mVXZCmV9qfN7gWOjSZVDV0fimxCEXAS_a30x9XD1aP0yerhSLm8SZM-CWJl25-BRx4rHwXLyLdcJ-5lcAq2Ll54B3-K9dVXR_w94gXgl9dWpcB_99On6dHqcfqcPfxudX91L_0akh4B1eNMmIXtej9cJwf2XCL0CDpcJwVBNpfeVqkl6ByW4Wb2Af5_yUWMAwe8dZDU340_vzxx96pawGgcXCe-yeCFcRMp1TzXxwELutm15WcEitletWANK5y71MWkLmduh0SN_3VpR6QuOzn0iEqrd52a_H26QFAPoRHrlIPup-bTuTKPyPSDFnQeN_HIB60Pg2BX2VZ2wCQtvYR2nJZoxVwn6bfpH9I_QbOlf4YG-w7-HqXPeHNd3rThA8CW2qVheHdqaNaPbLYepMoLe80xUHHqB2sjvAVGifryNSWjzpOzXoLJq7vp89UD1hd_s3ookiVq7DSZ33GHzQk8ewEgudglRG10NTBgCzy0Q1RRGNvA_Pnq8eqekv529Rj-AwR_D2nP0v8U-tES4yDh2uPk8neaohum0u12lU6nwzER0rBlpDfSgGQwGFwwUUU4cAQs2aOiy8RpXCJcXEVORk0mGx-ZyRyiVzwNYC5ydq2pC7CDaAcMG-BcIg-gBZm4toqqnskWzU3Z7Fxc3oTnKncOy5YwShuIi6Z8iMvr2GPdLu98CEEuPQtTZOL39BOIf1wi0waSVm1Uo_jXplPXIcovQYuRog1HmmYvFFXpwJdwUdai2AbJ3I1yJczhmZUI54EP1sP2vFxcDZiDFOhCA2U4HB6jwi9cIkKUHShdAd0o9DswXbZVCFX0NdE2cvdsWmcY_SptaRLFaTMC5-A9bYP-tk39kijKlujWutpK87_ZWVui2RcwMyFzdSFN17plU1wiVU4HPIZ_QlwwillGCcA6Rc2iolRLExNJHIKxdveI1VB6yEsb-gb7p7WHvUtcIpLFC0qsik6h5OtRNxljaAv7oNi-XU3IWYBRmBSp4VmxLIRCSw81gUGxEZo8tmEdcWNjIf-S9EUxciWEcSR25Mwzu4jy0RTL9UPm3HahCpg80IV5qqzugTfzIH2mpN_QOSX9n_Qv6Q_K6sHqK8iHCZT7POnz9I_4LVtGiLASr-5tWEmElXgoMiZBNr3rc1jJBT6P2AI0bKSu9TOMCsUaLwMJwfND4vUhYni4HoA5DF5ucLjbFByGFl6GIYkcmy2-aqLEemd9lFgfNEaJ9aZwU0OU2MjGuozauqHXy8G1YPWCVgZdmXyoAkHeLGja6smbrTEwmURBiFGTV9-MfTTHs6XHFvCnjfO_QAvWx_lcJ-ag021uQQ7X-kbpsDlZNEk9cU2TmGZv4PTE3JMVe1kRQ-DpB2r-XFwKHaKZcMDG4BqO-eAvGkWUQ8a4tsHV0jERBRqay-iaFR8OzsGSGpux58Ikpmq6Om5_Ec6q2LJ5pdc7NcBmBjD78zIwJlP8ZRjL2DXEWHSJDGdsGBLZ7h6I8_oPejZA6wd9t3v6QT-ZDIc8Og0cwE9XUVS2v0qZZivBNRahIyEaL8dcJwP1H5eeG89fH0s6aNgxHfzEoKIXMnFcInDgrMbZ6XXDtGkXund6TAn8GEYjbKh3BtueS_bLMYxuYfRLi6--FGHKCPCwQQ4-F90PBFwne7JnJUjo2Ak44cKC79gJmQXRobINjjlMefFIqZRI7JkoATXetGclYnSUMmIwowkLXFxNXTIRYv4TpMZKnq7ATEFcIl7XQCpuL5N5EInqXDDJbZpQrlHjRyzYoYnGaWpQIcXgwLlOz1wnmz1wW8E9YBidYApBnelcItfUNnS9u6EPMSAwvJRvdzAFncRu2qnDLl7eMXq7XXfcblKvXDAvHXSia396Rdm-Dp9fbX_8yfaHn1xcUX5x7bry2bVbQn6pHEw4WVHer-huUU4xXiZJIAVwgWrn2tWb2zs3lVs31tNnQVOwPGI1wsKagra8ZwW496xetg0m0x4TyKE6lejPe0St3StfM4bWnDEwu6ZtTvINWFmLBi-sLw6DrUUTKDqWaRn5DmCxwHGxMa2mwAtjel5cJzVMHXAcZDN_UfDmowcszHoKVCoFXm_bfTLEiko1u_9ZjwsP2Q5g5h2YQJp-u7q7erS6S8Nuq4fpd-mR8n_PFGlj0FlGiKd6SOzoc-WyzTfEcDHWvBZrbbGDhbjx1ca4HwvtiQpXD-DrV6tH6f-mz9plw5QJmx28Eb0OiPgm4gu63D10RObBApzCj4Dh3vk6h-tWMRgIb5_B4-5OesN-9-weN3ZItPmqzHVCpvbSy7a_8nxVUp1uy3eNIdtvw3lNopsLv4Odoxz2p04W5NcrC9DXI3a4vtXMBpe-0zuXgBNFynjzkDIakDLODynzjUPKaFh6m4PzQ6rz5iHVEO41O-eHVPfNQ0prQEo7P6R6bxxSLztIcxKk-Lb1TxB5NbH5z4RTp8Ged7XTb5blOJ3RXcHrNFwnDba-lruPZkPHaw5jm3WAjo3xYDx9AUANZEh3R15xlPXsnbJp8J7FzA3Gw67dfM8HK-OHdv8_TAbnZeKgLI8jCZT6r_tEYK5HArhq7e6xkXd-L0_E8nis9FXo3H9RYzRo3o2hxzPjxF0EPkhm0cAtbdlcXNduna7X4n3bm5yLrmUtoMf1m1sIKht7wczy3IWbWMS3xx7fTZA3NSgJDaBQOrEkZ3Mcxu0oAT9Ha5EDh0Sh4MaJD0ksVsyUGHdQFkFE8hgsO1wwdTc9Sn-Lx1vvpd-kR1xcKVpCbN30sxO7onkxexwc8HghH57JPFwiRMS-cbeEH0614rmN1YpcMDGwZ2eQV_dGXCLkUSUH6PdcXIfE_EwVu16KWx62Q8ZBsCsumOKm_r6bJOzKqcFEmYXeMs42pMMgSqaB5wZUo-wkMj1qiEeydRHmyQnp2dqIeHaCjcNPwpkyBc-UQuZ4WvgB1-xx-qOS_jd8_VpJv8fzwtUqBAMJZSaOIQLwVdo1eNfyRRXkqRpve-RUYRR8QZzEmpDEdr1YDmUh3VRk0K0JbIMOawNxwE2vEOVIXDAQO54rBTvLlC9tFwdEJYswOWzauaGbjcUTzG_6rg0915nYpcNXd3BAnKR9QLgb2eh620KvtIWME7UQ3R5jG9ju20Z65Y1knqiRoPhnxI7ets4rbZ07zP8pTdWy65DN14MCWa0vMsh9EaqSvrbIS_JHTK1QA7j2HsH7Rux6U3kPfdhAXFy43cRMRjiF9q86FLpYj7P8elwnXCIvLzkOQ-FBOoHtzDHE0eRB6RJdrQNlSAQV_8k0qDt6P_06fU49qKeZB4WpuRel13BZ40SZNaRrfKg6rhUXqiMRrfeg0BMsAlHbPfsy1Yl6p7auxEvqnNjf8gqO6ZuD9bQ1XdOZN3dNlr--a7L8StekXCcYmO5WbQWGMGkFsrwePKq2H9TyKldGT6URewHLLVjZFox9zA0985DpzUXEcg21NM-D5tuTSQQmUPnYnwbZpZ11zt0pWANo1xxnGdrSLcL1PsnpGF85gJU8ePgOaWRsno4xXDC9AwtU5cau67EBtZZz59Qw75AocaewtE9IM-vuqVgDzZXJ0jkOZB7aRHYN46CTU6wZCRKPyliA0h2tc9yJ9X53VDkksdfOZmaDHleXzqizHE67SdnEm1CPOp7VH03_yY_940Cm5wmHG4ax0TE2tPbgUhZ8IVEURBRcJ3dmcVTKt7by-Fxc4cJWfu5IvkwlbhdjtUXmL-OtXCJDcUyRShKrwXFcJxUL3uJr5P8h9TH-n790POpQ82NsGZr2GNqZYpq9JoD2ddHaBdgzEuFPfL_6Kv0Wr_b9BZyKI7zT9yj9A3yec39CkxjgpdnlXCJ_i0MXunH6I_ghR6t_T58o6X8oRZbUX8GL4V-nTyHlG4W-MuHXSFqtDYNsj4B09VwwnZrfpX_ixYG8rSA1EP6buKX_RyjxRNxv57zxLNQjenv_OV5Ff756CEm_ViD1Pgj5DeQdoVww94EL1PGkLBWvv8p_dRcSf8_uP2J1R_DwOP0zfJ61L14QnS0DqXS3siPuVvpgvGN-UMdAWPGOMt6rROW-FrqUBE2_g8z_YreXw630N1DtV4jz6hG-X2L1ELRDTSgV8vkBRH3Kzml9n_6AB7dyHzGHCW9pQj7o83R1r41gIbiPmLYPsAzyh3x4OKItAyWOUJyn0DAyPvxmKK2DE7Uvb4ZbwhzHMGzE8fDKW5nkfG5_C_nDPJ_ONAuyGJOodFxcHgN3NVQWGvmwfLS-L0vEVw5lfr0aGvR46Hn5MkOJWLh7DfJlHmGJ3ThI5tn7Bzktd7bK3DoVirWyFUhZn5Tj6BK6-0FcMPPagkROpRFkOCQy7tNWmkxSYDwO0XOrkEhtkLgLcBvGNXyQiLnwaPvQrYiTQpyVvf9imJEJMHx7IRYHuXtfS1k8PC17kA1s5SXCybgaXCfgilsynuvsnpipeTIEsByYbP8YtmyO5tsBS8Q7iZYOuh_S-hPqvjl3YwVv4ynw9xbe5KBvVBHEYjVcXOQwTxYeWxFpxbc7LH0Vr8KqOPSFP9Vir8Ipka2h2JLOu-Jl6s_ZaxsqHGIS8tfbSPlzXWTz4wmtrVtX_-HKdWXn2tUbN6_f2rn58bWrYHd1Qd_J2GVcJxpaWzfAEUlwRCvcK1ESxGjfPlRgpJC4rdxI4Huy9Mnkb4Bbh3OTBMlfNdEpQ3eMrzp4Gb5qocZX7bWe8ipM6cYqBkyKgDngUTkBd9Q0fKXLz90FGnEFvNH33hVXUdGLjNts29EO3ZgCBWX_nu16fvChGx3aPgxdTdsw4dOBTxc-Pfj0Ne3dS-9fvHDxQruuA4_GZArz_O2LF0TCu-8CtVwwZqTY4xjWLgmBRDTUYMsuXlwwfOhfJW9wdjJ3pLDXW3S7G0r-n9bWNRRh350kc9BT-xk8sBMD4ukOE0-WDER6p1YMBX5QAqVLi-IjlUx6VndxFOc71iOFfsUw0D-_p_3sUv742XsqFLskyi2CL89SKj5DoeD0ZeoLUIq6XCIIahKrsUOtjeIuZojpwj7gxzVGSt8IDxjhXFxvcyOxAQ-ddm40WJlo5vq0zd8J7Qkm0we6Wc464Uhp8W7Y2lCa9t_L9d1mumX77iNlqFGpaMPmh0sK6ZR6X2ihaTyZyany3pFR82R2nwFyaMYZZef9HO9KdMw-06VcMNc7ONZkQYxhJkix8PsVzQ2jXnOTt5M49BBOLXzpcj7b9THWsvSTKHuJXoGEej_S0XqJVpdoY28pbKlTocAgRR6CGWRMlNLOll6kLlSN7mepWLaDwgsJGfReJoQqO4z04su8pD5eEOWuaixcMCgQFaQY5NR5vLKIgBQNlUiKEEiV1mAgkxcx6FfLZSDwUhkIUlC5iMIgi26WoIA55FdubOcXwspEBWEkar1MLYRcMJq9GppcIhhdxqgMRK-GvoiGWSx4mK1SpGIZHCYTpQhFl8f1KjjchNRCpHc9CIJUL5BKCCSCoMcJ6HKtGO1EJspHmB6LhVSZtKi7Jpcp6MKKZHprLFnN1oj4FhfXpzGi_O2a4gUgklMhQvadLPeLamZWFFwnTXrYWt4Y0Aq542ByiBGjwm2pQYWE-AUeOn17kOtbDVwiDisKiBf35c4cc45KisGqjb1tmcdQx3S7BLsqvWueBHQfgx4cFJlD_qZUuUDx7VwwM2sKbuIyXCITi77dmdPgVb_8xQHo8vI3BfJKsxdnibfk83RNvg2bpXbpgC8ezalpFosvP-PSK6QLvmTG1MRTuYQGKKyY3tDL9aOA4C06S5zKDcK88J2_AiYHphs';

					


					if ( !function_exists( 'themestek_cs_decode_string' ) ) {
						function themestek_cs_decode_string( $string ) {

							// decode the encrypted theme opitons
							$options = unserialize( gzuncompress( stripslashes( call_user_func( 'base'. '64' .'_decode', rtrim( strtr( $string, '-_', '+/' ), '=' ) ) ) ) );

							// changing image path with client website url so image will be fetched from client server directly
							$demo_domains = array(
								'https://liviza-demo.pbminfotech.com/datasite/',
								'https://liviza-demo.pbminfotech.com/demo1/',
								'https://liviza-demo.pbminfotech.com/demo2/',
								'https://liviza-demo.pbminfotech.com/demo3/',
								'https://liviza-demo.pbminfotech.com/liviza-rtl/',
								'https://liviza-demo.pbminfotech.com/',
							);

							// getting current site URL
							$current_url = get_site_url() . '/';

							foreach( $options as $key=>$val ){
								if( !empty($val) && is_string($val) ){
									if( is_string($val) && substr($val,0,7) == 'http://' ){
										$val = str_replace( $demo_domains, $current_url, $val );
										$options[$key] = $val;
									}
								}
							}


							return $options;
						}
					}

					// Update theme options according to selected layout

					if( !empty($theme_options[$layout_type]) ){
						$new_options = themestek_cs_decode_string( $theme_options[$layout_type] );
						// Image path URL change is pending
						// we need to replace image path with correct path 
						$custom_code_fields = array(
							'minify',
							'custom_css_code',
							'custom_js_code',
							'customhtml_head',
							'customhtml_bodystart',
							'customhtml_bodyend',
						);
						foreach( $custom_code_fields as $field ){
							if ( isset( $new_options[ $field ] ) ){
								if( $field == 'minify' ){
									$new_options[ $field ] = true;
								} else {
									$new_options[ $field ] = '';
								}
							}
						}
						update_option('liviza_theme_options', $new_options);
					}


					/**** END CodeStart theme options import ****/

					/**** START - Edit "Hello World" post and change *****/
					$hello_world_post = get_post(1);
					if( !empty($hello_world_post) ){
						$newDate = array(
							'ID'		=> '1',
							'post_date'	=> "2014-12-10 0:0:0" // [ Y-m-d H:i:s ]
						);

						wp_update_post($newDate);
					}
					/**** END - Edit "Hello World" post and change *****/





			        // Import custom configuration
					$content = file_get_contents( THEMESTEK_LIVIZA_DIR .'demo-content-setup/one-click-demo/'.$filename );

					if ( false !== strpos( $content, '<wp:theme_custom>' ) ) {
						preg_match('|<wp:theme_custom>(.*?)</wp:theme_custom>|is', $content, $config);
						if ($config && is_array($config) && count($config) > 1){
							$config = unserialize(base64_decode($config[1]));
							if (is_array($config)){
								$configs = array(
										'page_for_posts',
										'show_on_front',
										'page_on_front',
										'posts_per_page',
										'sidebars_widgets',
									);
								foreach ($configs as $item){
									if (isset($config[$item])){
										if( $item=='page_for_posts' || $item=='page_on_front' ){
											$query = new WP_Query( array( 'post_type' => 'page', 'title' => $config[$item],	) );
											if ( ! empty( $query->post ) ) {
												$page = $query->post;
												if( isset($page->ID) ){
													$config[$item] = $page->ID;
												}
											}
										}
										update_option($item, $config[$item]);
									}
								}
								if (isset($config['sidebars_widgets'])){
									$sidebars = $config['sidebars_widgets'];
									update_option('sidebars_widgets', $sidebars);
									// read config
									$sidebars_config = array();
									if (isset($config['sidebars_config'])){
										$sidebars_config = $config['sidebars_config'];
										if (is_array($sidebars_config)){
											foreach ($sidebars_config as $name => $widget){
												update_option('widget_'.$name, $widget);
											}
										}
									}
								}

								if ( isset($config['menu_list']) && is_array($config['menu_list']) && count($config['menu_list'])>0 ){
									foreach( $config['menu_list'] as $location=>$menu_name ){
										$locations = get_theme_mod('nav_menu_locations'); // Get all menu Locations of current theme

										// Get menu name by id
										$term = get_term_by('name', $menu_name, 'nav_menu');
										$menu_id = $term->term_id;

										$locations[$location] = $menu_id;  //$foo is term_id of menu
										set_theme_mod('nav_menu_locations', $locations); // Set menu locations
									}
								}
							}
						}
						
						// Change homepage slider according to selected header
						if( $layout_type == 'overlay' ){
							// Change Homepage
							$query = new WP_Query( array( 'post_type' => 'page', 'title' => 'Homepage-1' ) );
							if ( ! empty( $query->post ) ) {
								$front_page_id = $query->post;
								if( isset($front_page_id->ID) && !empty($front_page_id->ID) ){
									update_option( 'show_on_front' , 'page' );
									update_option( 'page_on_front', $front_page_id->ID );
								}
							}

						} else if( $layout_type == 'infostack' ){
							// Change Homepage
							$query = new WP_Query( array( 'post_type' => 'page', 'title' => 'Homepage-2' ) );
							if ( ! empty( $query->post ) ) {
								$front_page_id = $query->post;
								if( isset($front_page_id->ID) && !empty($front_page_id->ID) ){
									update_option( 'show_on_front' , 'page' );
									update_option( 'page_on_front', $front_page_id->ID );
								}
							}

						} else if( $layout_type == 'classic' ){ // demo 3
							// Change Homepage
							$query = new WP_Query( array( 'post_type' => 'page', 'title' => 'Homepage-3' ) );
							if ( ! empty( $query->post ) ) {
								$front_page_id = $query->post;
								if( isset($front_page_id->ID) && !empty($front_page_id->ID) ){
									update_option( 'show_on_front' , 'page' );
									update_option( 'page_on_front', $front_page_id->ID );
								}
							}
						} 
					}

					// Update term count in admin section
					themestek_update_term_count();
					flush_rewrite_rules(); // flush rewrite rule

					$answer['answer'] = 'finished';
					$answer['reload'] = 'yes';
					die( json_encode( $answer ) );

				break;

			}
			die;
		}



		/**
		 * Fetch and save image
		 **/
		function grab_image($url,$saveto){
			$ch = curl_init ($url);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
			$raw=curl_exec($ch);
			curl_close ($ch);
			if(file_exists($saveto)){
				unlink($saveto);
			}
			$fp = fopen($saveto,'x');
			fwrite($fp, $raw);
			fclose($fp);
		}



	} // END class

} // END if



if( !function_exists('themestek_update_term_count') ){
function themestek_update_term_count(){
	$get_taxonomies = get_taxonomies();
	foreach( $get_taxonomies as $taxonomy=>$taxonomy2 ){
		$terms = get_terms( $taxonomy, 'hide_empty=0' );
		$terms_array = array();
		foreach( $terms as $term ){
			$terms_array[] = $term->term_id;
		}
		if( !empty($terms_array) && count($terms_array)>0 ){
			$output = wp_update_term_count_now( $terms_array, $taxonomy );
		}
	}
}
}




// For AJAX callback
$themestek_liviza_one_click_demo_setup = new themestek_liviza_one_click_demo_setup;
