<?php
/**
 * @package Bravis-Themes
 */
$archive_readmore_text = immigway()->get_theme_opt('archive_readmore_text', esc_html__('Read Article', 'immigway'));
$archive_excerpt_line = immigway()->get_theme_opt('archive_excerpt_line', 2);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
    <div class="pxl-item-inner">
        <?php if (has_post_thumbnail()) { 
                echo '<div class="pxl-item--image">'; ?>
                    <a href="<?php echo esc_url( get_permalink()); ?>" ><?php the_post_thumbnail('immigway-large'); ?></a>
                <?php echo '</div>';
            } ?>
        <div class="pxl-item--holder">
            <?php immigway()->blog->get_archive_meta(); ?>
            <h5 class="pxl-item--title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php if(is_sticky()) { ?>
                        <i class="caseicon-check-mark pxl-mr-4"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h5>
            <div class="pxl-item--excerpt pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($archive_excerpt_line); ?>;">
                <?php
                immigway()->blog->get_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
                ?>
            </div>
            <div class="pxl-item--readmore">
                <a class="btn--readmore" href="<?php echo esc_url( get_permalink()); ?>">
                    <span class="btn-readmore--text"><?php echo immigway_html($archive_readmore_text); ?></span>
                    <span class="btn-readmore--icon pxl-ml-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                </a>
            </div>
        </div>
    </div>
</article>