<?php
/**
 * Filters hook for the theme
 *
 * @package Bravis-Themes
 */

/* Custom Classs - Body */
function immigway_body_classes( $classes ) {   

	$classes[] = '';
    if (class_exists('ReduxFramework')) {
        $classes[] = ' pxl-redux-page';

	    $footer_fixed = immigway()->get_theme_opt('footer_fixed');
	    $p_footer_fixed = immigway()->get_page_opt('p_footer_fixed');

	    if($p_footer_fixed != false && $p_footer_fixed != 'inherit') {
	    	$footer_fixed = $p_footer_fixed;
	    }

	    if(isset($footer_fixed) && $footer_fixed == 'on') {
	        $classes[] = ' pxl-footer-fixed';
	    }

	    $pxl_body_typography = immigway()->get_theme_opt('pxl_body_typography');
	    if($pxl_body_typography != 'google-font') {
	        $classes[] = ' body-'.$pxl_body_typography.' ';
	    }

	    $pxl_heading_typography = immigway()->get_theme_opt('pxl_heading_typography');
	    if($pxl_heading_typography != 'google-font') {
	        $classes[] = ' heading-'.$pxl_heading_typography.' ';
	    }

	    $theme_default = immigway()->get_theme_opt('theme_default');
	    if(isset($theme_default['font-family']) && $theme_default['font-family'] == false && $pxl_body_typography == 'google-font') {
	        $classes[] = ' pxl-font-default';
	    }

	    $header_layout = immigway()->get_opt('header_layout');
	    if(isset($header_layout) && $header_layout) {
		    $post_header = get_post($header_layout);
		    $header_type = get_post_meta( $post_header->ID, 'header_type', true );
		    if(isset($header_type)) {
		    	$classes[] = ' bd-'.$header_type.'';
		    }
		}

	    $get_gradient_color = immigway()->get_opt('gradient_color');
		if($get_gradient_color['from'] == $get_gradient_color['to'] ) {
		    $classes[] = ' site-color-normal ';
		} else {
			$classes[] = ' site-color-gradient ';
		}

		$shop_layout = immigway()->get_theme_opt('shop_layout', 'grid');
		if(isset($_GET['shop-layout'])) {
	        $shop_layout = $_GET['shop-layout'];
	    }
		$classes[] = ' woocommerce-layout-'.$shop_layout;

		$body_custom_class = immigway()->get_page_opt('body_custom_class');
		if(!empty($body_custom_class)) {
			$classes[] = $body_custom_class;
		}
    }
    return $classes;
}
add_filter( 'body_class', 'immigway_body_classes' );

/* Post Type Support */
function immigway_add_cpt_support() {
    $cpt_support = get_option( 'elementor_cpt_support' );
    
    if( ! $cpt_support ) {
        $cpt_support = [ 'page', 'post', 'case_studies', 'service', 'visa','careers','country', 'footer', 'pxl-template' ];
        update_option( 'elementor_cpt_support', $cpt_support );
    }
    
    else if( ! in_array( 'case_studies', $cpt_support ) ) {
        $cpt_support[] = 'case_studies';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'service', $cpt_support ) ) {
        $cpt_support[] = 'service';
        update_option( 'elementor_cpt_support', $cpt_support );
    }
    else if( ! in_array( 'careers', $cpt_support ) ) {
        $cpt_support[] = 'careers';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'visa', $cpt_support ) ) {
        $cpt_support[] = 'visa';
        update_option( 'elementor_cpt_support', $cpt_support );
    } 

    else if( ! in_array( 'country', $cpt_support ) ) {
        $cpt_support[] = 'country';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'footer', $cpt_support ) ) {
        $cpt_support[] = 'footer';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'pxl-template', $cpt_support ) ) {
        $cpt_support[] = 'pxl-template';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

}
add_action( 'after_switch_theme', 'immigway_add_cpt_support');

add_filter( 'pxl_support_default_cpt', 'immigway_support_default_cpt' );
function immigway_support_default_cpt($postypes){
	return $postypes; // pxl-template
}

add_filter( 'pxl_extra_post_types', 'immigway_add_posttype' );
function immigway_add_posttype( $postypes ) {
	$case_studies_display = immigway()->get_theme_opt('case_studies_display', true);
	$case_studies_slug = immigway()->get_theme_opt('case_studies_slug', 'case-studies');
	$case_studies_name = immigway()->get_theme_opt('case_studies_name', 'Case Studies');
	$service_display = immigway()->get_theme_opt('service_display', true);
	$service_slug = immigway()->get_theme_opt('service_slug', 'service');
	$service_name = immigway()->get_theme_opt('service_name', 'Services');
	$careers_display = immigway()->get_theme_opt('careers_display', true);
	$careers_slug = immigway()->get_theme_opt('careers_slug', 'careers');
	$careers_name = immigway()->get_theme_opt('careers_name', 'Careers');
	$visa_display = immigway()->get_theme_opt('visa_display', true);
	$visa_slug = immigway()->get_theme_opt('visa_slug', 'Visa');
	$visa_name = immigway()->get_theme_opt('visa_name', 'Visa');
	$country_display = immigway()->get_theme_opt('country_display', true);
	$country_slug = immigway()->get_theme_opt('country_slug', 'Country');
	$country_name = immigway()->get_theme_opt('country_name', 'Country');
	if($case_studies_display) {
		$case_studies_status = true;
	} else {
		$case_studies_status = false;
	}
	if($service_display) {
		$service_status = true;
	} else {
		$service_status = false;
	}
	if($careers_display) {
		$careers_status = true;
	} else {
		$careers_status = false;
	}
	if($visa_display) {
		$visa_status = true;
	} else {
		$visa_status = false;
	}
	if($country_display) {
		$country_status = true;
	} else {
		$country_status = false;
	}

	$postypes['case_studies'] = array(
		'status' => $case_studies_status,
		'item_name'  => $case_studies_name,
		'items_name' => $case_studies_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $case_studies_slug,
 		 	),
		),
	);

	$postypes['service'] = array(
		'status' => $service_status,
		'item_name'  => $service_name,
		'items_name' => $service_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $service_slug,
 		 	),
		),
	);
	$postypes['careers'] = array(
		'status' => $careers_status,
		'item_name'  => $careers_name,
		'items_name' => $careers_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $careers_slug,
 		 	),
		),
	);

	$postypes['visa'] = array(
		'status' => $visa_status,
		'item_name'  => $visa_name,
		'items_name' => $visa_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $visa_slug,
 		 	),
		),
	);

	$postypes['country'] = array(
		'status' => $country_status,
		'item_name'  => $country_name,
		'items_name' => $country_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $country_slug,
 		 	),
		),
	);
  
	return $postypes;
}

/* Custom Archive Post Type Link */
function immigway_custom_archive_service_link() {
    if( is_post_type_archive( 'service' ) ) {
    	$archive_service_link = immigway()->get_theme_opt('archive_service_link');
        wp_redirect( get_permalink($archive_service_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'immigway_custom_archive_service_link' );

function immigway_custom_archive_careers_link() {
    if( is_post_type_archive( 'careers' ) ) {
    	$archive_careers_link = immigway()->get_theme_opt('archive_careers_link');
        wp_redirect( get_permalink($archive_careers_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'immigway_custom_archive_careers_link' );

function immigway_custom_archive_visa_link() {
    if( is_post_type_archive( 'visa' ) ) {
    	$archive_visa_link = immigway()->get_theme_opt('archive_visa_link');
        wp_redirect( get_permalink($archive_visa_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'immigway_custom_archive_visa_link' );

function immigway_custom_archive_country_link() {
    if( is_post_type_archive( 'country' ) ) {
    	$archive_country_link = immigway()->get_theme_opt('archive_country_link');
        wp_redirect( get_permalink($archive_visa_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'immigway_custom_archive_country_link' );

function immigway_custom_archive_case_studies_link() {
    if( is_post_type_archive( 'case_studies' ) ) {
        $archive_case_studies_link = immigway()->get_theme_opt('archive_case_studies_link');
        wp_redirect( get_permalink($archive_case_studies_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'immigway_custom_archive_case_studies_link' );

add_filter( 'pxl_extra_taxonomies', 'immigway_add_tax' );
function immigway_add_tax( $taxonomies ) {

	$taxonomies['case-studies-category'] = array(
		'status'     => true,
		'post_type'  => array( 'case_studies' ),
		'taxonomy'   => 'Case Studies Categories',
		'taxonomies' => 'Case Studies Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'case-studies-category'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['service-category'] = array(
		'status'     => true,
		'post_type'  => array( 'service' ),
		'taxonomy'   => 'Service Categories',
		'taxonomies' => 'Service Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service-category'
 		 	),
		),
		'labels'     => array()
	);
	$taxonomies['careers-category'] = array(
		'status'     => true,
		'post_type'  => array( 'careers' ),
		'taxonomy'   => 'Careers Categories',
		'taxonomies' => 'Careers Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'careers-category'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['visa-category'] = array(
		'status'     => true,
		'post_type'  => array( 'visa' ),
		'taxonomy'   => 'Visa Categories',
		'taxonomies' => 'Visa Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'visa-category'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['country-category'] = array(
		'status'     => true,
		'post_type'  => array( 'country' ),
		'taxonomy'   => 'Country Categories',
		'taxonomies' => 'Country Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'country-category'
 		 	),
		),
		'labels'     => array()
	);
	
	return $taxonomies;
}

add_filter( 'pxl_theme_builder_post_types', 'immigway_theme_builder_post_type' );
function immigway_theme_builder_post_type($postypes){
	//default are header, footer, mega-menu
	return $postypes;
}

add_filter( 'pxl_theme_builder_layout_ids', 'immigway_theme_builder_layout_id' );
function immigway_theme_builder_layout_id($layout_ids){
	//default [], 
	$header_layout        = (int)immigway()->get_opt('header_layout');
	$header_sticky_layout = (int)immigway()->get_opt('header_sticky_layout');
	$footer_layout        = (int)immigway()->get_opt('footer_layout');
	$ptitle_layout        = (int)immigway()->get_opt('ptitle_layout');
	if( $header_layout > 0) 
		$layout_ids[] = $header_layout;
	if( $header_sticky_layout > 0) 
		$layout_ids[] = $header_sticky_layout;
	if( $footer_layout > 0) 
		$layout_ids[] = $footer_layout;
	if( $ptitle_layout > 0) 
		$layout_ids[] = $ptitle_layout;

	$slider_template = immigway_get_templates_option('slider');
	if( count($slider_template) > 0){
		foreach ($slider_template as $key => $value) {
			$layout_ids[] = $key;
		}
	}

	$tab_template = immigway_get_templates_option('tab');
	if( count($tab_template) > 0){
		foreach ($tab_template as $key => $value) {
			$layout_ids[] = $key;
		}
	}

	$tab_template = immigway_get_templates_option('accordion');
	if( count($tab_template) > 0){
		foreach ($tab_template as $key => $value) {
			$layout_ids[] = $key;
		}
	}
	
	$mega_menu_id = immigway_get_mega_menu_builder_id();
	if(!empty($mega_menu_id))
		$layout_ids = array_merge($layout_ids, $mega_menu_id);

	$page_popup_id = immigway_get_page_popup_builder_id();
	if(!empty($page_popup_id))
		$layout_ids = array_merge($layout_ids, $page_popup_id);

	return $layout_ids;
}

add_filter( 'pxl_wg_get_source_id_builder', 'immigway_wg_get_source_builder' );
function immigway_wg_get_source_builder($wg_datas){
  $wg_datas['tabs'] = ['control_name' => 'tabs', 'source_name' => 'content_template'];
  $wg_datas['slides'] = ['control_name' => 'slides', 'source_name' => 'slide_template'];
  return $wg_datas;
}

/* Update primary color in Editor Builder */
add_action( 'elementor/preview/enqueue_styles', 'immigway_add_editor_preview_style' );
function immigway_add_editor_preview_style(){
    wp_add_inline_style( 'editor-preview', immigway_editor_preview_inline_styles() );
}
function immigway_editor_preview_inline_styles(){
    $theme_colors = immigway_configs('theme_colors');
    ob_start();
        echo '.elementor-edit-area-active{';
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
        echo '}';
    return ob_get_clean();
}
 
add_filter( 'get_the_archive_title', 'immigway_archive_title_remove_label' );
function immigway_archive_title_remove_label( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} elseif ( is_home() ) {
		$title = single_post_title( '', false );
	}

	return $title;
}

add_filter( 'comment_reply_link', 'immigway_comment_reply_text' );
function immigway_comment_reply_text( $link ) {
	$link = str_replace( 'Reply', ''.esc_attr__('Reply', 'immigway').'', $link );
	return $link;
}
add_filter( 'pxl_enable_pagepopup', 'immigway_enable_pagepopup' );
function immigway_enable_pagepopup() {
	return true;
}
add_filter( 'pxl_enable_megamenu', 'immigway_enable_megamenu' );
function immigway_enable_megamenu() {
	return true;
}
add_filter( 'pxl_enable_onepage', 'immigway_enable_onepage' );
function immigway_enable_onepage() {
	return true;
}

add_filter( 'pxl_support_awesome_pro', 'immigway_support_awesome_pro' );
function immigway_support_awesome_pro() {
	return true;
}
 
add_filter( 'redux_pxl_iconpicker_field/get_icons', 'immigway_add_icons_to_pxl_iconpicker_field' );
function immigway_add_icons_to_pxl_iconpicker_field($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


add_filter("pxl_mega_menu/get_icons", "immigway_add_icons_to_megamenu");
function immigway_add_icons_to_megamenu($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}
 

/**
 * Move comment field to bottom
 */
add_filter( 'comment_form_fields', 'immigway_comment_field_to_bottom' );
function immigway_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}


/* ------Disable Lazy loading---- */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );

/* ------ Export Settings ---- */
add_filter( 'pxl_export_wp_settings', 'immigway_export_wp_settings' );
function immigway_export_wp_settings($wp_options){
  $wp_options[] = 'mc4wp_default_form_id';
  return $wp_options;
}

/* ------ Theme Info ---- */
add_filter( 'pxl_server_info', 'immigway_add_server_info');
function immigway_add_server_info($infos){
  $infos = [
    'api_url' => 'https://api.bravisthemes.com/',
    'docs_url' => 'https://doc.bravisthemes.com/immigway/',
    'plugin_url' => 'https://api.bravisthemes.com/plugins/',
    'demo_url' => 'https://demo.bravisthemes.com/immigway/',
    'support_url' => 'bravisthemes.com@gmail.com',
    'help_url' => 'https://doc.bravisthemes.com/immigway',
    'email_support' => 'bravisthemes.com@gmail.com',
    'video_url' => '#'
  ];
  
  return $infos;
}

/* ------ Template Filter ---- */
add_filter( 'pxl_template_type_support', 'immigway_template_type_support' );
function immigway_template_type_support($type) {
	$extra_type = [
		'page-title'          => esc_html__('Page Title', 'immigway'), 
		'hidden-panel'          => esc_html__('Hidden Panel', 'immigway'), 
		'tab'          => esc_html__('Tab', 'immigway'), 
		'popup'          => esc_html__('Popup', 'immigway'),
		'slider'          => esc_html__('Slider', 'immigway'),
	];
	$template_type = array_merge($type,$extra_type); 
	return $template_type;
}

/* Search Result  */
function immigway_custom_post_types_in_search_results( $query ) {
    if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        $query->set( 'post_type', array( 'post', 'case_studies', 'service','careers','visa','country', 'product' ) );
    }
}
add_action( 'pre_get_posts', 'immigway_custom_post_types_in_search_results' );