<?php if(!function_exists('immigway_configs')){
    function immigway_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'immigway'), 
                    'value' => immigway()->get_opt('primary_color', '#e13833')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'immigway'), 
                    'value' => immigway()->get_opt('secondary_color', '#162842')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'immigway'), 
                    'value' => immigway()->get_opt('third_color', '#666666')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'immigway'), 
                    'value' => immigway()->get_page_opt('body_bg_color', '#fff')
                ]
            ],
            'link' => [
                'color' => immigway()->get_opt('link_color', ['regular' => '#e13833'])['regular'],
                'color-hover'   => immigway()->get_opt('link_color', ['hover' => '#162842'])['hover'],
                'color-active'  => immigway()->get_opt('link_color', ['active' => '#162842'])['active'],
            ],
            'gradient' => [
                'color-from' => immigway()->get_opt('gradient_color', ['from' => '#00C6FF'])['from'],
                'color-to' => immigway()->get_opt('gradient_color', ['to' => '#0072FF'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('immigway_inline_styles')) {
    function immigway_inline_styles() {  
        
        $theme_colors      = immigway_configs('theme_colors');
        $link_color        = immigway_configs('link');
        $gradient_color    = immigway_configs('gradient');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  immigway_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
        echo '}';

        return ob_get_clean();
         
    }
}
 