<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
$templates = immigway_get_templates_option('slider', []) ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_slider',
        'title' => esc_html__('BR Slider', 'immigway'),
        'icon' => 'eicon-slider-device',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'immigway'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'item_active',
                            'label' => esc_html__( 'Active Slide', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 1,
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'slide_height',
                            'label' => esc_html__('Slider Height', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-slider--inner' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Type', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'default',
                            'options' => [
                                'default' => esc_html__('Default', 'immigway' ),
                                'style-2' => esc_html__('Style 2', 'immigway' ),
                            ],
                        ),
                        array(
                            'name' => 'slides',
                            'label' => esc_html__('Slides', 'immigway'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'style' => ['default'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                ),
                                array(
                                    'name' => 'slide_template',
                                    'label' => esc_html__('Select Template', 'immigway'),
                                    'type' => 'select',
                                    'options' => $templates,
                                    'default' => 'df',
                                    'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' )) . '" target="_blank">Click Here</a>"',
                                ),
                                array(
                                    'name' => 'bg_color',
                                    'label' => esc_html__('Background Color', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-element-slider .pxl-slider--inner{{CURRENT_ITEM}}' => 'background-color: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'bg_image',
                                    'label' => esc_html__('Background Image', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'bg_ken_burns',
                                    'label' => esc_html__('Background Ken Burns', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::SWITCHER,
                                    'default' => 'false',
                                ),
                                array(
                                    'name' => 'overlay_color',
                                    'label' => esc_html__('Overlay Color', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-element-slider .pxl-slider--overlay{{CURRENT_ITEM}}' => 'background-color: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'overlay_image',
                                    'label' => esc_html__('Overlay Image', 'immigway' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'slides_l2',
                            'label' => esc_html__('Slides', 'immigway'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'style' => ['style-2'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'slide_template_l2',
                                    'label' => esc_html__('Select Template', 'immigway'),
                                    'type' => 'select',
                                    'options' => $templates,
                                    'default' => 'df',
                                    'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' )) . '" target="_blank">Click Here</a>"',
                                ),
                            ),
                        ),
                        array(
                            'name' => 'content_align',
                            'label' => esc_html__( 'Content Vertical Align', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'condition' => [
                                'style' => ['default'],
                            ],
                            'options' => [
                                'flex-start' => [
                                    'title' => esc_html__( 'Top', 'immigway' ),
                                    'icon' => 'eicon-v-align-top',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Middle', 'immigway' ),
                                    'icon' => 'eicon-v-align-middle',
                                ],
                                'flex-end' => [
                                    'title' => esc_html__( 'Bottom', 'immigway' ),
                                    'icon' => 'eicon-v-align-bottom',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-element-slider .pxl-slider--content' => 'align-items: {{VALUE}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'section_settings_carousel',
    'label' => esc_html__('Settings', 'immigway'),
    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
    'controls' => array(
        array(
            'name' => 'arrows',
            'label' => esc_html__('Show Arrows', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'show_title',
            'label' => esc_html__('Show Title', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'pagination',
            'label' => esc_html__('Show Pagination', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'pagination_type',
            'label' => esc_html__('Pagination Type', 'immigway' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'bullets',
            'options' => [
                'bullets' => 'Bullets',
                'fraction' => 'Fraction',
            ],
            'condition' => [
                'pagination' => 'true'
            ]
        ),
        array(
            'name' => 'pagination_bullet_style',
            'label' => esc_html__('Bullets Style', 'immigway' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'style-6',
            'options' => [
                'style-1' => 'Style 1',
                'style-2' => 'Style 2',
                'style-3' => 'Style 3',
                'style-4' => 'Style 4',
                'style-5' => 'Style 5',
                'style-6' => 'Style 6',
            ],
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'pagination_bullet_style_horizonta_or_vertical',
            'label' => esc_html__('Horizontal Or Vertical', 'immigway' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'style-horizontal',
            'options' => [
                'style-horizontal' => 'Horizontal',
                'style-vertical' => 'Vertical Left',
                'style-vertical-right' => 'Vertical Right',
            ],
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'type_position',
            'label' => esc_html__('Position', 'icoland' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'position-left' => 'Left',
                'position-bottom' => 'Bottom',
                'position-right' => 'Right',
            ],
            'default' => 'position-bottom',
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'pagination_color',
            'label' => esc_html__('Color Pagination', 'immigway' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-swiper-dots span' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'pagination_color_active',
            'label' => esc_html__('Color Pagination Active', 'immigway' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-swiper-dots .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'border_pagination_color_active',
            'label' => esc_html__('Border Color Pagination Active', 'immigway' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-swiper-dots .swiper-pagination-bullet-active:before, {{WRAPPER}} .pxl-swiper-dots .swiper-pagination-bullet-active:after ' => 'border-color: {{VALUE}};',
            ],
            'condition' => [
                'pagination_type' => 'bullets'
            ]
        ),
        array(
            'name' => 'pause_on_hover',
            'label' => esc_html__('Pause on Hover', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
        ),
        array(
            'name' => 'autoplay',
            'label' => esc_html__('Autoplay', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
        ),
        array(
            'name' => 'autoplay_speed',
            'label' => esc_html__('Autoplay Delay', 'immigway'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 5000,
            'condition' => [
                'autoplay' => 'true'
            ]
        ),
        array(
            'name' => 'infinite',
            'label' => esc_html__('Infinite Loop', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
        ),
        array(
            'name' => 'speed',
            'label' => esc_html__('Animation Speed', 'immigway'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 500,
        ),
        array(
            'name' => 'progressbar',
            'label' => esc_html__('Show Progress Bar', 'immigway'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
    ),
),
),
),
),
immigway_get_class_widget_path()
);