<?php
namespace MailPoetVendor\Twig\Profiler\Dumper;
if (!defined('ABSPATH')) exit;
use MailPoetVendor\Twig\Profiler\Profile;
final class HtmlDumper extends BaseDumper
{
 private static $colors = ['block' => '#dfd', 'macro' => '#ddf', 'template' => '#ffd', 'big' => '#d44'];
 public function dump(Profile $profile) : string
 {
 return '<pre>' . parent::dump($profile) . '</pre>';
 }
 protected function formatTemplate(Profile $profile, $prefix) : string
 {
 return \sprintf('%s└ <span style="background-color: %s">%s</span>', $prefix, self::$colors['template'], $profile->getTemplate());
 }
 protected function formatNonTemplate(Profile $profile, $prefix) : string
 {
 return \sprintf('%s└ %s::%s(<span style="background-color: %s">%s</span>)', $prefix, $profile->getTemplate(), $profile->getType(), self::$colors[$profile->getType()] ?? 'auto', $profile->getName());
 }
 protected function formatTime(Profile $profile, $percent) : string
 {
 return \sprintf('<span style="color: %s">%.2fms/%.0f%%</span>', $percent > 20 ? self::$colors['big'] : 'auto', $profile->getDuration() * 1000, $percent);
 }
}
