<?php
/**
 * Admin Class.
 *
 * @author Bravis-Themes Team
 * @package Bravis User
 * @version 1.0.0
 */
if (! defined ( 'ABSPATH' )) {
	exit (); // Exit if accessed directly
}

if (! class_exists ( 'Bravis_User_admin' )) {

	class Bravis_User_admin {  

		function __construct() {
                    
			add_action( 'admin_init', array(
				$this,
				'register_plugin_settings' ));


			// add admin page.
			add_action ( 'admin_menu', array (
				$this,
				'add_admin_page'
			) );

			// get current tab content.
			add_action( 'pxl-user-form/inc/admin/tab/content', array(
				$this,
				'add_admin_tab_content'
			));
			
			add_filter( 'plugin_action_links_' . bravisuser()->basename, array( $this, 'plugin_action_links' ) );
		}

		/**
		 * register settings.
		 *
		 * @package Bravis User
		 */
		function register_plugin_settings() {
 
            /* reservation options Email . */
            
            register_setting('pxl-user-form-email-group', 'pxl_user_subjepxl_email');
            register_setting('pxl-user-form-email-group', 'pxl_user_email_send');
            register_setting('pxl-user-form-email-group', 'pxl-user-form-conten-email');
                        
                      
		}
		
		/**
		 * Show action links on the plugin screen.
		 *
		 * @param	mixed $links Plugin Action links
		 * @return	array
		 */
		function plugin_action_links( $links ){
			
			$action_links = array(
                 'settings' => '<a href="' . admin_url( 'users.php?page=pxl-user-form_admin' ) . '" title="' . esc_attr( esc_html__( 'View Bravis Users Settings', 'bravis-user' ) ) . '">' . esc_html__( 'Settings', 'bravis-user' ) . '</a>',
			);
			
			return array_merge( $action_links, $links );
		}
		
		/**
		 * Add admin pages.
		 *
		 * @package Bravis User
		 */
		function add_admin_page() {
			add_users_page ( esc_html__ ( 'Bravis Users', 'bravis-user' ), esc_html__ ( 'Bravis Users', 'bravis-user' ), 'manage_options', 'pxl-user-form_admin', array (
				$this,
				'add_admin_page_main'
			) );
		}

		/**
		 * Admin page options.
		 *
		 * General, Products, Reservation, Custom Fields ...
		 * @package Bravis User
		 */
		function add_admin_page_main() {
			 
			?>
			<h1><?php esc_html_e('Bravis User', 'bravis-user'); ?></h1>
			<p><?php esc_html_e('A wordpress user manager plugin.', 'bravis-user'); ?></p>
			<div class="wrap news-twitter">
				<form id="mainform" method="post" action="options.php">
					<div class="news-twitter-woocommerce-settings" id="icon-woocommerce">
						<br />
					</div>
					<h2 class="nav-tab-wrapper woo-nav-tab-wrapper">
						<a href="<?php echo admin_url( 'users.php?page=pxl-user-form_admin&tab=email' ); ?>" class="nav-tab nav-tab-active"><?php echo esc_html__('Email Settings', 'bravis-user'); ?></a>
					</h2>

					<?php  do_action('pxl-user-form/inc/admin/tab/content'); ?>

					<?php submit_button(); ?>

				</form>
			</div>
			<?php
		}

		/**
		 * Admin tab options.
		 *
		 * content tabs.
		 * @package Bravis User
		 */
		function add_admin_tab_content() {

			$tab = apply_filters('pxl-user-form/inc/admin/tab/template', bravisuser()->plugin_dir . "admin/html_tab_email.php");

			if(!file_exists($tab)) return ;

			settings_fields( "pxl-user-form-email-group" );
			do_settings_sections( "pxl-user-form-email-group" );

			require_once $tab;
 
		}
		
		/**
		 * Text field.
		 * 
		 * @param array $options
		 */
		private function option_text($options){
				
			$option_value = get_option( $options['id'], $options['default'] );
                       
			?>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
				</th>
				<td class="forminp">
					<input name="<?php echo esc_attr( $options['id'] ); ?>" id="<?php echo esc_attr( $options['id'] ); ?>" type="text" value="<?php echo esc_attr( $option_value ); ?>" placeholder="<?php echo esc_attr( $options['placeholder'] ); ?>" />
                                        <label><?php echo $options['description'] ?></label>
				</td>
			</tr>
			<?php
		}
			
		/**
		 * Select field.
		 *
		 * @param array $options
		 */
		private function option_select($options){
			
			$option_value = get_option( $options['id'], $options['default'] );

			?>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
				</th>
				<td class="forminp">
					<select name="<?php echo esc_attr( $options['id'] ); ?>" id="<?php echo esc_attr( $options['id'] ); ?>">
						<?php foreach ($options['options'] as $key => $item): ?>
						<option value="<?php echo esc_attr($key); ?>"<?php if($option_value == $key){ echo ' selected="selected"'; } ?>><?php echo esc_html($item); ?></option>
						<?php endforeach; ?>
					</select>
				</td>
			</tr>
			<?php
		}
		
                 /**
		 * field. select color`
		 * 
		 * @param array $options
		 */
            private function option_color($options){

                    $option_value = get_option( $options['id'], $options['default'] );

                    ?>
                    <tr valign="top" class="pxl-user-form-option-color">
                            <th scope="row" class="titledesc">
                                    <label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
                            </th>
                            <td class="forminp">
                             <input name="<?php echo esc_attr( $options['id'] ); ?>" id="<?php echo esc_attr( $options['id'] ); ?>" type="text" class="demo"  data-opacity="0.50" data-format="rgb" value="<?php echo esc_attr( $option_value ); ?>"/>
                            </td>
                    </tr>
                    <?php
            } 
                
            private function option_image($options){

                    $option_value = get_option( $options['id'], $options['default'] );

                            ?>
                            <tr valign="top" class="pxl-user-form-option-media">
                                    <th scope="row" class="titledesc">
                                            <label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
                                            <td class="forminp">
                                                <input name="<?php echo esc_attr( $options['id'] ); ?>" id="<?php echo esc_attr( $options['id'] ); ?>" type="text" value="<?php echo esc_attr( $option_value ); ?>"/>
                                                <button type="button" class="button button-primary"><span class="dashicons dashicons-admin-media"></span></button>
                                            </td>
                                    </th>
                            </tr>
                            <?php
            }

            private function option_layout($options){

                    $option_value = get_option( $options['id'], $options['default'] );

                    ?>
                    <tr valign="top" class="pxl-user-form-option-layout">
                                    <th scope="row" class="titledesc">
                                            <label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
                                            <td class="forminp">
                                                    <ul>
                                                            <?php $template = up_get_template_list();
                                                            foreach ($template as $value): ?>

                                                            

                                                            <?php endforeach; ?>
                                                    </ul>
                                                    <input name="<?php echo esc_attr( $options['id'] ); ?>" type="hidden" id="<?php echo esc_attr( $options['id'] ); ?>" type="text" value="<?php echo esc_attr( $option_value ); ?>"/>
                                            </td>
                                    </th>
                            </tr>
                    <?php
            }   
		 /**
		  * Switch Option.
		  * 
		  * @copyright http://codepen.io/BandarRaffah/pen/ibwje
		  * @param array() $options
		  */
         private  function option_switch($options)
         {
         	
         	$option_value = get_option( $options['id'], $options['default'] );
         	
         	?>
         	<tr valign="top" class="pxl-user-form-option-switch">
				<th scope="row" class="titledesc">
					<label for="<?php echo esc_attr( $options['id'] ); ?>"><?php echo esc_html( $options['title'] ); ?></label>
				</th>
				<td class="forminp">
					<label><input type="checkbox" class="ios-switch green"<?php if($option_value) { echo ' checked="checked"'; } ?>/><div class="switch"><div></div></div></label>
					<input name="<?php echo esc_attr( $options['id'] ); ?>" id="<?php echo esc_attr( $options['id'] ); ?>" type="hidden" value="<?php echo esc_attr( $option_value ); ?>"/>
				</td>
			</tr>
         	<?php
         }
	}

	new Bravis_User_admin ();
}